/*
 * Decompiled with CFR 0.152.
 */
package org.csource.fastdfs;

import java.io.IOException;
import java.io.InputStream;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.util.ArrayList;
import java.util.Properties;
import org.csource.common.FastdfsException;
import org.csource.common.IniFileReader;
import org.csource.fastdfs.TrackerGroup;

public class ClientGlobal {
    public static final String CONF_KEY_CONNECT_TIMEOUT = "connect_timeout";
    public static final String CONF_KEY_NETWORK_TIMEOUT = "network_timeout";
    public static final String CONF_KEY_CHARSET = "charset";
    public static final String CONF_KEY_HTTP_ANTI_STEAL_TOKEN = "http.anti_steal_token";
    public static final String CONF_KEY_HTTP_SECRET_KEY = "http.secret_key";
    public static final String CONF_KEY_HTTP_TRACKER_HTTP_PORT = "http.tracker_http_port";
    public static final String CONF_KEY_TRACKER_SERVER = "tracker_server";
    public static final String PROP_KEY_CONNECT_TIMEOUT_IN_SECONDS = "fastdfs.connect_timeout_in_seconds";
    public static final String PROP_KEY_NETWORK_TIMEOUT_IN_SECONDS = "fastdfs.network_timeout_in_seconds";
    public static final String PROP_KEY_CHARSET = "fastdfs.charset";
    public static final String PROP_KEY_HTTP_ANTI_STEAL_TOKEN = "fastdfs.http_anti_steal_token";
    public static final String PROP_KEY_HTTP_SECRET_KEY = "fastdfs.http_secret_key";
    public static final String PROP_KEY_HTTP_TRACKER_HTTP_PORT = "fastdfs.http_tracker_http_port";
    public static final String PROP_KEY_TRACKER_SERVERS = "fastdfs.tracker_servers";
    public static final int DEFAULT_CONNECT_TIMEOUT = 5;
    public static final int DEFAULT_NETWORK_TIMEOUT = 30;
    public static final String DEFAULT_CHARSET = "UTF-8";
    public static final boolean DEFAULT_HTTP_ANTI_STEAL_TOKEN = false;
    public static final String DEFAULT_HTTP_SECRET_KEY = "FastDFS1234567890";
    public static final int DEFAULT_HTTP_TRACKER_HTTP_PORT = 80;
    public static int connectTimeout = 5000;
    public static int networkTimeout = 30000;
    public static String charset = "UTF-8";
    public static boolean antiStealToken = false;
    public static String secretKey = "FastDFS1234567890";
    public static int trackerHttpPort = 80;
    public static TrackerGroup trackerGroup;

    private ClientGlobal() {
    }

    public static void init(String conf_filename) throws IOException, FastdfsException {
        String[] szTrackerServers;
        IniFileReader iniReader = new IniFileReader(conf_filename);
        connectTimeout = iniReader.getIntValue(CONF_KEY_CONNECT_TIMEOUT, 5);
        if (connectTimeout < 0) {
            connectTimeout = 5;
        }
        connectTimeout *= 1000;
        networkTimeout = iniReader.getIntValue(CONF_KEY_NETWORK_TIMEOUT, 30);
        if (networkTimeout < 0) {
            networkTimeout = 30;
        }
        networkTimeout *= 1000;
        charset = iniReader.getStrValue(CONF_KEY_CHARSET);
        if (charset == null || charset.length() == 0) {
            charset = "ISO8859-1";
        }
        if ((szTrackerServers = iniReader.getValues(CONF_KEY_TRACKER_SERVER)) == null) {
            throw new FastdfsException("item \"tracker_server\" in " + conf_filename + " not found");
        }
        InetSocketAddress[] tracker_servers = new InetSocketAddress[szTrackerServers.length];
        for (int i = 0; i < szTrackerServers.length; ++i) {
            String[] parts = szTrackerServers[i].split("\\:", 2);
            if (parts.length != 2) {
                throw new FastdfsException("the value of item \"tracker_server\" is invalid, the correct format is host:port");
            }
            tracker_servers[i] = new InetSocketAddress(parts[0].trim(), Integer.parseInt(parts[1].trim()));
        }
        trackerGroup = new TrackerGroup(tracker_servers);
        trackerHttpPort = iniReader.getIntValue(CONF_KEY_HTTP_TRACKER_HTTP_PORT, 80);
        antiStealToken = iniReader.getBoolValue(CONF_KEY_HTTP_ANTI_STEAL_TOKEN, false);
        if (antiStealToken) {
            secretKey = iniReader.getStrValue(CONF_KEY_HTTP_SECRET_KEY);
        }
    }

    public static void initByProperties(String propsFilePath) throws IOException, FastdfsException {
        Properties props = new Properties();
        InputStream in = IniFileReader.loadFromOsFileSystemOrClasspathAsStream(propsFilePath);
        if (in != null) {
            props.load(in);
        }
        ClientGlobal.initByProperties(props);
    }

    public static void initByProperties(Properties props) throws IOException, FastdfsException {
        String trackerServersConf = props.getProperty(PROP_KEY_TRACKER_SERVERS);
        if (trackerServersConf == null || trackerServersConf.trim().length() == 0) {
            throw new FastdfsException(String.format("configure item %s is required", PROP_KEY_TRACKER_SERVERS));
        }
        ClientGlobal.initByTrackers(trackerServersConf.trim());
        String connectTimeoutInSecondsConf = props.getProperty(PROP_KEY_CONNECT_TIMEOUT_IN_SECONDS);
        String networkTimeoutInSecondsConf = props.getProperty(PROP_KEY_NETWORK_TIMEOUT_IN_SECONDS);
        String charsetConf = props.getProperty(PROP_KEY_CHARSET);
        String httpAntiStealTokenConf = props.getProperty(PROP_KEY_HTTP_ANTI_STEAL_TOKEN);
        String httpSecretKeyConf = props.getProperty(PROP_KEY_HTTP_SECRET_KEY);
        String httpTrackerHttpPortConf = props.getProperty(PROP_KEY_HTTP_TRACKER_HTTP_PORT);
        if (connectTimeoutInSecondsConf != null && connectTimeoutInSecondsConf.trim().length() != 0) {
            connectTimeout = Integer.parseInt(connectTimeoutInSecondsConf.trim()) * 1000;
        }
        if (networkTimeoutInSecondsConf != null && networkTimeoutInSecondsConf.trim().length() != 0) {
            networkTimeout = Integer.parseInt(networkTimeoutInSecondsConf.trim()) * 1000;
        }
        if (charsetConf != null && charsetConf.trim().length() != 0) {
            charset = charsetConf.trim();
        }
        if (httpAntiStealTokenConf != null && httpAntiStealTokenConf.trim().length() != 0) {
            antiStealToken = Boolean.parseBoolean(httpAntiStealTokenConf);
        }
        if (httpSecretKeyConf != null && httpSecretKeyConf.trim().length() != 0) {
            secretKey = httpSecretKeyConf.trim();
        }
        if (httpTrackerHttpPortConf != null && httpTrackerHttpPortConf.trim().length() != 0) {
            trackerHttpPort = Integer.parseInt(httpTrackerHttpPortConf);
        }
    }

    public static void initByTrackers(String trackerServers) throws IOException, FastdfsException {
        String[] arr1;
        ArrayList<InetSocketAddress> list = new ArrayList<InetSocketAddress>();
        String spr1 = ",";
        String spr2 = ":";
        for (String addrStr : arr1 = trackerServers.trim().split(spr1)) {
            String[] arr2 = addrStr.trim().split(spr2);
            String host = arr2[0].trim();
            int port = Integer.parseInt(arr2[1].trim());
            list.add(new InetSocketAddress(host, port));
        }
        InetSocketAddress[] trackerAddresses = list.toArray(new InetSocketAddress[list.size()]);
        ClientGlobal.initByTrackers(trackerAddresses);
    }

    public static void initByTrackers(InetSocketAddress[] trackerAddresses) throws IOException, FastdfsException {
        trackerGroup = new TrackerGroup(trackerAddresses);
    }

    public static Socket getSocket(String ip_addr, int port) throws IOException {
        Socket sock = new Socket();
        sock.setSoTimeout(networkTimeout);
        sock.connect(new InetSocketAddress(ip_addr, port), connectTimeout);
        return sock;
    }

    public static Socket getSocket(InetSocketAddress addr) throws IOException {
        Socket sock = new Socket();
        sock.setSoTimeout(networkTimeout);
        sock.connect(addr, connectTimeout);
        return sock;
    }

    public static int getConnectTimeout() {
        return connectTimeout;
    }

    public static void setConnectTimeout(int connect_timeout) {
        connectTimeout = connect_timeout;
    }

    public static int getNetworkTimeout() {
        return networkTimeout;
    }

    public static void setNetworkTimeout(int network_timeout) {
        networkTimeout = network_timeout;
    }

    public static String getCharset() {
        return charset;
    }

    public static void setCharset(String charset) {
        ClientGlobal.charset = charset;
    }

    public static int getTrackerHttpPort() {
        return trackerHttpPort;
    }

    public static void setTrackerHttpPort(int tracker_http_port) {
        trackerHttpPort = tracker_http_port;
    }

    public static boolean getAntiStealToken() {
        return antiStealToken;
    }

    public static boolean isAntiStealToken() {
        return antiStealToken;
    }

    public static void setAntiStealToken(boolean anti_steal_token) {
        antiStealToken = anti_steal_token;
    }

    public static String getSecretKey() {
        return secretKey;
    }

    public static void setSecretKey(String secret_key) {
        secretKey = secret_key;
    }

    public static TrackerGroup getTrackerGroup() {
        return trackerGroup;
    }

    public static void setTrackerGroup(TrackerGroup tracker_group) {
        trackerGroup = tracker_group;
    }

    public static String configInfo() {
        String trackerServers = "";
        if (trackerGroup != null) {
            InetSocketAddress[] trackerAddresses;
            for (InetSocketAddress inetSocketAddress : trackerAddresses = ClientGlobal.trackerGroup.tracker_servers) {
                if (trackerServers.length() > 0) {
                    trackerServers = trackerServers + ",";
                }
                trackerServers = trackerServers + inetSocketAddress.toString().substring(1);
            }
        }
        return "{\n  connect_timeout(ms) = " + connectTimeout + "\n  network_timeout(ms) = " + networkTimeout + "\n  charset = " + charset + "\n  anti_steal_token = " + antiStealToken + "\n  secret_key = " + secretKey + "\n  tracker_http_port = " + trackerHttpPort + "\n  trackerServers = " + trackerServers + "\n}";
    }
}

