/*
 * Decompiled with CFR 0.152.
 */
package io.buji.pac4j.context;

import java.util.Optional;
import org.apache.shiro.SecurityUtils;
import org.apache.shiro.UnavailableSecurityManagerException;
import org.apache.shiro.session.Session;
import org.apache.shiro.subject.support.DisabledSessionException;
import org.pac4j.core.context.JEEContext;
import org.pac4j.core.context.session.SessionStore;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ShiroSessionStore
implements SessionStore<JEEContext> {
    private static final Logger logger = LoggerFactory.getLogger(ShiroSessionStore.class);
    public static final ShiroSessionStore INSTANCE = new ShiroSessionStore();

    protected Session getSession(boolean createSession) {
        try {
            return SecurityUtils.getSubject().getSession(createSession);
        }
        catch (DisabledSessionException e) {
            return null;
        }
    }

    public String getOrCreateSessionId(JEEContext context) {
        Session session = this.getSession(true);
        if (session != null) {
            return session.getId().toString();
        }
        return null;
    }

    public Optional<Object> get(JEEContext context, String key) {
        Session session = this.getSession(false);
        if (session != null) {
            return Optional.ofNullable(session.getAttribute((Object)key));
        }
        return Optional.empty();
    }

    public void set(JEEContext context, String key, Object value) {
        Session session = this.getSession(true);
        if (session != null) {
            try {
                session.setAttribute((Object)key, value);
            }
            catch (UnavailableSecurityManagerException e) {
                logger.warn("Should happen just once at startup in some specific case of Shiro Spring configuration", (Throwable)e);
            }
        }
    }

    public boolean destroySession(JEEContext context) {
        this.getSession(true).stop();
        return true;
    }

    public Optional getTrackableSession(JEEContext context) {
        return Optional.empty();
    }

    public Optional<SessionStore<JEEContext>> buildFromTrackableSession(JEEContext context, Object trackableSession) {
        return Optional.empty();
    }

    public boolean renewSession(JEEContext context) {
        return false;
    }
}

