/*
 * Decompiled with CFR 0.152.
 */
package io.buji.pac4j.profile;

import io.buji.pac4j.util.ShiroHelper;
import java.util.LinkedHashMap;
import org.apache.shiro.SecurityUtils;
import org.apache.shiro.authc.AuthenticationException;
import org.pac4j.core.context.JEEContext;
import org.pac4j.core.context.WebContext;
import org.pac4j.core.context.session.SessionStore;
import org.pac4j.core.profile.CommonProfile;
import org.pac4j.core.profile.ProfileManager;

public class ShiroProfileManager
extends ProfileManager<CommonProfile> {
    public ShiroProfileManager(WebContext context) {
        super(context);
    }

    public ShiroProfileManager(WebContext context, SessionStore<JEEContext> sessionStore) {
        super(context, sessionStore);
    }

    protected void saveAll(LinkedHashMap<String, CommonProfile> profiles, boolean saveInSession) {
        super.saveAll(profiles, saveInSession);
        try {
            ShiroHelper.populateSubject(profiles);
        }
        catch (AuthenticationException e) {
            super.remove(saveInSession);
            throw e;
        }
    }

    public void remove(boolean removeFromSession) {
        super.remove(removeFromSession);
        SecurityUtils.getSubject().logout();
    }
}

