/*
 * Decompiled with CFR 0.152.
 */
package io.github.hylexus.oaks.utils;

import io.github.hylexus.oaks.ansi.AnsiEscapeCode;
import java.util.Locale;

public abstract class AnsiUtils {
    private static final String OS_NAME = System.getProperty("os.name").toLowerCase(Locale.ENGLISH);

    public static String buildString(boolean resetAllAnsiPropsAfterReturning, Object ... objects) {
        StringBuilder sb = new StringBuilder();
        boolean ansiPrefixAppended = false;
        boolean ansiOccurred = false;
        for (Object obj : objects) {
            if (obj == null) continue;
            if (obj instanceof AnsiEscapeCode) {
                ansiOccurred = true;
                if (ansiPrefixAppended) {
                    sb.append(";");
                } else {
                    sb.append("\u001b[");
                    ansiPrefixAppended = true;
                }
                sb.append(((AnsiEscapeCode)obj).getAnsiCode());
                continue;
            }
            if (ansiPrefixAppended) {
                sb.append("m");
                ansiPrefixAppended = false;
            }
            sb.append(obj);
        }
        if (resetAllAnsiPropsAfterReturning && ansiOccurred) {
            if (ansiPrefixAppended) {
                sb.append(";");
            } else {
                sb.append("\u001b[");
            }
            sb.append(AnsiEscapeCode.RESET).append("m");
        }
        return sb.toString();
    }
}

