/*
 * Decompiled with CFR 0.152.
 */
package io.github.hylexus.oaks.utils;

import io.github.hylexus.oaks.utils.Numbers;
import lombok.NonNull;

public abstract class BcdOps {
    public static String bytes2BcdString(@NonNull byte[] bytes, int start, int length) {
        if (bytes == null) {
            throw new NullPointerException("bytes is marked non-null but is null");
        }
        return BcdOps.bcd2String(bytes, start, start + length);
    }

    public static String bcd2String(byte[] bytes, int start, int end) {
        assert (start < end) : "start < end";
        int length = end - start;
        StringBuilder builder = new StringBuilder(length << 2);
        for (int i = start; i < end; ++i) {
            builder.append((bytes[i] & 0xF0) >>> 4);
            builder.append(bytes[i] & 0xF);
        }
        return "0".equalsIgnoreCase(builder.toString().substring(0, 1)) ? builder.toString().substring(1) : builder.toString();
    }

    public static String bcd2String(byte[] bytes) {
        return BcdOps.bcd2String(bytes, 0, bytes.length);
    }

    public static byte[] bcdString2bytes(String str) {
        return BcdOps.string2Bcd(str);
    }

    public static byte[] string2Bcd(String str) {
        String source = Numbers.isOdd(str.length()) ? "0" + str : str;
        byte[] result = new byte[source.length() >> 1];
        byte[] sourceBytes = source.getBytes();
        for (int i = 0; i < result.length; ++i) {
            byte high = BcdOps.ascii2Bcd(sourceBytes[i << 1]);
            byte low = BcdOps.ascii2Bcd(sourceBytes[(i << 1) + 1]);
            result[i] = (byte)(high << 4 | low);
        }
        return result;
    }

    private static byte ascii2Bcd(byte asc) {
        if (asc >= 48 && asc <= 57) {
            return (byte)(asc - 48);
        }
        if (asc >= 65 && asc <= 70) {
            return (byte)(asc - 65 + 10);
        }
        if (asc >= 97 && asc <= 102) {
            return (byte)(asc - 97 + 10);
        }
        return (byte)(asc - 48);
    }
}

