/*
 * Decompiled with CFR 0.152.
 */
package io.github.hylexus.oaks.utils;

import java.util.Arrays;
import java.util.List;
import java.util.function.Predicate;
import lombok.NonNull;

public abstract class Bytes {
    private static Predicate<byte[]> NOT_EMPTY_BYTE_ARRAY = bytes -> bytes != null && ((byte[])bytes).length > 0;

    public static byte[] concatAll(@NonNull byte[] first, byte[] ... rest) {
        if (first == null) {
            throw new NullPointerException("first is marked non-null but is null");
        }
        if (rest == null) {
            throw new NullPointerException("rest is marked non-null but is null");
        }
        return Bytes.concatAll(first, NOT_EMPTY_BYTE_ARRAY, rest);
    }

    public static byte[] concatAll(@NonNull byte[] first, Predicate<byte[]> predicate, byte[] ... rest) {
        if (first == null) {
            throw new NullPointerException("first is marked non-null but is null");
        }
        if (rest == null) {
            throw new NullPointerException("rest is marked non-null but is null");
        }
        int totalLength = first.length;
        for (byte[] array : rest) {
            if (!predicate.test(array)) continue;
            totalLength += array.length;
        }
        byte[] result = Arrays.copyOf(first, totalLength);
        int offset = first.length;
        for (byte[] array : rest) {
            if (!predicate.test(array)) continue;
            System.arraycopy(array, 0, result, offset, array.length);
            offset += array.length;
        }
        return result;
    }

    public static byte[] concatAll(@NonNull List<byte[]> rest) {
        if (rest == null) {
            throw new NullPointerException("rest is marked non-null but is null");
        }
        return Bytes.concatAll(rest, NOT_EMPTY_BYTE_ARRAY);
    }

    public static byte[] concatAll(@NonNull List<byte[]> rest, Predicate<byte[]> predicate) {
        if (rest == null) {
            throw new NullPointerException("rest is marked non-null but is null");
        }
        int totalLength = 0;
        for (byte[] array : rest) {
            if (!predicate.test(array)) continue;
            totalLength += array.length;
        }
        byte[] result = new byte[totalLength];
        int offset = 0;
        for (byte[] array : rest) {
            if (!predicate.test(array)) continue;
            System.arraycopy(array, 0, result, offset, array.length);
            offset += array.length;
        }
        return result;
    }

    public static byte[] range(@NonNull byte[] bytes, int start, int end) {
        if (bytes == null) {
            throw new NullPointerException("bytes is marked non-null but is null");
        }
        assert (start < end) : "start < end";
        return Bytes.subSequence(bytes, start, end - start);
    }

    public static byte[] subSequence(@NonNull byte[] bytes, int startIndex, int length) {
        if (bytes == null) {
            throw new NullPointerException("bytes is marked non-null but is null");
        }
        byte[] tmp = new byte[length];
        System.arraycopy(bytes, startIndex, tmp, 0, length);
        return tmp;
    }
}

