/*
 * Decompiled with CFR 0.152.
 */
package io.github.hylexus.oaks.utils;

import lombok.NonNull;

public abstract class IntBitOps {
    private static final int MASK = 255;

    public static byte intToByte(int i) {
        return (byte)(i & 0xFF);
    }

    public static byte[] intTo1Byte(int i) {
        return new byte[]{IntBitOps.intToByte(i)};
    }

    public static int intFrom1Byte(@NonNull byte[] bytes, int startIndex) {
        if (bytes == null) {
            throw new NullPointerException("bytes is marked non-null but is null");
        }
        return bytes[startIndex] & 0xFF;
    }

    public static int intFrom1Byte(byte b) {
        return b & 0xFF;
    }

    public static byte[] intTo2Bytes(int value) {
        return new byte[]{(byte)(value >>> 8 & 0xFF), (byte)(value & 0xFF)};
    }

    public static int intFrom2Bytes(@NonNull byte[] bytes, int startIndex) {
        if (bytes == null) {
            throw new NullPointerException("bytes is marked non-null but is null");
        }
        return (bytes[startIndex] & 0xFF) << 8 | bytes[startIndex + 1] & 0xFF;
    }

    public static int intFrom2Bytes(@NonNull byte[] bytes) {
        if (bytes == null) {
            throw new NullPointerException("bytes is marked non-null but is null");
        }
        return IntBitOps.intFrom2Bytes(bytes, 0);
    }

    public static byte[] intTo3Bytes(int value) {
        return new byte[]{(byte)(value >>> 16 & 0xFF), (byte)(value >>> 8 & 0xFF), (byte)(value & 0xFF)};
    }

    public static int intFrom3Bytes(@NonNull byte[] bytes, int startIndex) {
        if (bytes == null) {
            throw new NullPointerException("bytes is marked non-null but is null");
        }
        return (bytes[startIndex] & 0xFF) << 16 | (bytes[startIndex + 1] & 0xFF) << 8 | bytes[startIndex + 2] & 0xFF;
    }

    public static int intFrom3Bytes(@NonNull byte[] bytes) {
        if (bytes == null) {
            throw new NullPointerException("bytes is marked non-null but is null");
        }
        return IntBitOps.intFrom3Bytes(bytes, 0);
    }

    public static byte[] intTo4Bytes(int value) {
        return new byte[]{(byte)(value >>> 24 & 0xFF), (byte)(value >>> 16 & 0xFF), (byte)(value >>> 8 & 0xFF), (byte)(value & 0xFF)};
    }

    public static int intFrom4Bytes(@NonNull byte[] bytes) {
        if (bytes == null) {
            throw new NullPointerException("bytes is marked non-null but is null");
        }
        return IntBitOps.intFrom4Bytes(bytes, 0);
    }

    public static int intFrom4Bytes(@NonNull byte[] bytes, int startIndex) {
        if (bytes == null) {
            throw new NullPointerException("bytes is marked non-null but is null");
        }
        return (bytes[startIndex] & 0xFF) << 24 | (bytes[startIndex + 1] & 0xFF) << 16 | (bytes[startIndex + 2] & 0xFF) << 8 | bytes[startIndex + 3] & 0xFF;
    }

    public static int intFromBytes(@NonNull byte[] bytes, int start, int len) {
        if (bytes == null) {
            throw new NullPointerException("bytes is marked non-null but is null");
        }
        switch (len) {
            case 1: {
                return IntBitOps.intFrom1Byte(bytes, start);
            }
            case 2: {
                return IntBitOps.intFrom2Bytes(bytes, start);
            }
            case 3: {
                return IntBitOps.intFrom3Bytes(bytes, start);
            }
            case 4: {
                return IntBitOps.intFrom4Bytes(bytes, start);
            }
        }
        throw new IllegalArgumentException("len \u2208 [1,4]");
    }

    public static int intFromBytes(@NonNull byte[] bytes) {
        if (bytes == null) {
            throw new NullPointerException("bytes is marked non-null but is null");
        }
        return IntBitOps.intFromBytes(bytes, 0, bytes.length);
    }
}

