/*
 * Decompiled with CFR 0.152.
 */
package io.github.hylexus.oaks.utils;

import lombok.NonNull;

public abstract class LongBitOps {
    private static final long MASK = 255L;
    private static final int BYTE_COUNT_OF_LONG = 8;

    public static byte longToByte(long i) {
        return (byte)(i & 0xFFL);
    }

    public static byte[] longTo1Byte(int i) {
        return new byte[]{LongBitOps.longToByte(i)};
    }

    public static byte[] longTo8Bytes(long value) {
        byte[] bytes = new byte[8];
        for (int i = 0; i < 8; ++i) {
            bytes[i] = LongBitOps.byteAt(7 - i << 3, value);
        }
        return bytes;
    }

    public static long longFrom8Bytes(@NonNull byte[] bytes) {
        if (bytes == null) {
            throw new NullPointerException("bytes is marked non-null but is null");
        }
        return LongBitOps.longFrom8Bytes(bytes, 0);
    }

    public static long longFrom8Bytes(@NonNull byte[] bytes, int startIndex) {
        if (bytes == null) {
            throw new NullPointerException("bytes is marked non-null but is null");
        }
        long value = 0L;
        for (int i = 0; i < 8; ++i) {
            value |= ((long)bytes[startIndex + i] & 0xFFL) << (7 - i << 3);
        }
        return value;
    }

    public static byte byteAt(int index, long value) {
        return (byte)(value >>> index & 0xFFL);
    }
}

