/*
 * Decompiled with CFR 0.152.
 */
package io.github.hylexus.oaks.utils;

import java.util.Optional;

public abstract class Numbers {
    public static boolean isOdd(int number) {
        return (number & 1) != 0;
    }

    public static boolean isEven(int number) {
        return (number & 1) == 0;
    }

    public static boolean isPositive(Number n) {
        return n != null && n.doubleValue() > 0.0;
    }

    public static boolean isNegative(Number n) {
        return n != null && n.doubleValue() < 0.0;
    }

    public static Optional<Integer> parseInteger(Object object) {
        return Numbers.parseInteger(object.toString());
    }

    public static Optional<Integer> parseInteger(String string) {
        try {
            return Optional.of(Integer.parseInt(string));
        }
        catch (Exception e) {
            return Optional.empty();
        }
    }

    public static Optional<Long> parseLong(Object object) {
        return Numbers.parseLong(object.toString());
    }

    public static Optional<Long> parseLong(String string) {
        try {
            return Optional.of(Long.parseLong(string));
        }
        catch (Exception e) {
            return Optional.empty();
        }
    }

    public static Optional<Float> parseFloat(Object object) {
        return Numbers.parseFloat(object.toString());
    }

    public static Optional<Float> parseFloat(String string) {
        try {
            return Optional.of(Float.valueOf(Float.parseFloat(string)));
        }
        catch (Exception e) {
            return Optional.empty();
        }
    }

    public static Optional<Double> parseDouble(Object object) {
        return Numbers.parseDouble(object.toString());
    }

    public static Optional<Double> parseDouble(String string) {
        try {
            return Optional.of(Double.parseDouble(string));
        }
        catch (Exception e) {
            return Optional.empty();
        }
    }

    public static int getBitAt(long value, int index) {
        return (int)(((long)(1 << index) & value) >> index);
    }

    public static int getBitAt(int value, int index) {
        return (1 << index & value) >> index;
    }

    public static int setBitAt(int value, int index) {
        return 1 << index | value;
    }

    public static long setBitAt(long value, int index) {
        return (long)(1 << index) | value;
    }

    public static int setBitAt(int value, int index, boolean flag) {
        return flag ? Numbers.setBitAt(value, index) : Numbers.resetBitAt(value, index);
    }

    public static long setBitAt(long value, int index, boolean flag) {
        return flag ? Numbers.setBitAt(value, index) : Numbers.resetBitAt(value, index);
    }

    public static int resetBitAt(int value, int index) {
        return value & ~(1 << index);
    }

    public static long resetBitAt(long value, int index) {
        return value & (long)(~(1 << index));
    }

    public static int getBitRangeAsInt(int number, int start, int end) {
        return number << 32 - (end + 1) >>> 32 - (end - start + 1);
    }

    public static long getBitRangeAsLong(long number, int start, int end) {
        return number << 64 - (end + 1) >>> 64 - (end - start + 1);
    }
}

