/*
 * Decompiled with CFR 0.152.
 */
package io.github.lukehutch.fastclasspathscanner.json;

import io.github.lukehutch.fastclasspathscanner.json.ClassFieldCache;
import io.github.lukehutch.fastclasspathscanner.json.FieldTypeInfo;
import io.github.lukehutch.fastclasspathscanner.json.Id;
import io.github.lukehutch.fastclasspathscanner.json.JSONUtils;
import io.github.lukehutch.fastclasspathscanner.json.TypeResolutions;
import java.lang.reflect.Field;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;

class ClassFields {
    final List<FieldTypeInfo> fieldOrder = new ArrayList<FieldTypeInfo>();
    final Map<String, FieldTypeInfo> fieldNameToFieldTypeInfo = new HashMap<String, FieldTypeInfo>();
    Field idField;

    public ClassFields(Class<?> cls, boolean resolveTypes, boolean onlySerializePublicFields, ClassFieldCache classFieldCache) {
        HashSet<String> visibleFieldNames = new HashSet<String>();
        ArrayList fieldSuperclassReversedOrder = new ArrayList();
        TypeResolutions currTypeResolutions = null;
        Type currType = cls;
        while (currType != Object.class && currType != null) {
            Class<?> currRawType;
            ParameterizedType currParameterizedType;
            if (currType instanceof ParameterizedType) {
                currParameterizedType = (ParameterizedType)currType;
                currRawType = (Class<?>)currParameterizedType.getRawType();
            } else if (currType instanceof Class) {
                currParameterizedType = null;
                currRawType = currType;
            } else {
                throw new IllegalArgumentException("Illegal class type: " + currType);
            }
            Field[] fields = currRawType.getDeclaredFields();
            ArrayList<FieldTypeInfo> fieldOrderWithinClass = new ArrayList<FieldTypeInfo>();
            for (int i = 0; i < fields.length; ++i) {
                Field field = fields[i];
                if (!visibleFieldNames.add(field.getName())) continue;
                boolean isIdField = field.isAnnotationPresent(Id.class);
                if (isIdField) {
                    if (this.idField != null) {
                        throw new IllegalArgumentException("More than one @Id annotation: " + this.idField.getDeclaringClass() + "." + this.idField + " ; " + currRawType.getName() + "." + field.getName());
                    }
                    this.idField = field;
                }
                if (JSONUtils.fieldIsSerializable(field, onlySerializePublicFields)) {
                    Type fieldGenericType = field.getGenericType();
                    Type fieldTypePartiallyResolved = currTypeResolutions != null && resolveTypes ? currTypeResolutions.resolveTypeVariables(fieldGenericType) : fieldGenericType;
                    FieldTypeInfo fieldTypeInfo = new FieldTypeInfo(field, fieldTypePartiallyResolved, classFieldCache);
                    this.fieldNameToFieldTypeInfo.put(field.getName(), fieldTypeInfo);
                    fieldOrderWithinClass.add(fieldTypeInfo);
                    continue;
                }
                if (!isIdField) continue;
                throw new IllegalArgumentException("@Id annotation field must be accessible, final, and non-transient: " + currRawType.getName() + "." + field.getName());
            }
            fieldSuperclassReversedOrder.add(fieldOrderWithinClass);
            Type genericSuperType = currRawType.getGenericSuperclass();
            if (resolveTypes) {
                if (genericSuperType instanceof ParameterizedType) {
                    Type resolvedSupertype = currTypeResolutions == null ? genericSuperType : currTypeResolutions.resolveTypeVariables(genericSuperType);
                    currTypeResolutions = resolvedSupertype instanceof ParameterizedType ? new TypeResolutions((ParameterizedType)resolvedSupertype) : null;
                    currType = resolvedSupertype;
                    continue;
                }
                if (genericSuperType instanceof Class) {
                    currType = genericSuperType;
                    currTypeResolutions = null;
                    continue;
                }
                throw new IllegalArgumentException("Got unexpected supertype " + genericSuperType);
            }
            currType = genericSuperType;
        }
        for (int i = fieldSuperclassReversedOrder.size() - 1; i >= 0; --i) {
            List fieldGroupingForClass = (List)fieldSuperclassReversedOrder.get(i);
            this.fieldOrder.addAll(fieldGroupingForClass);
        }
    }
}

