/*
 * Decompiled with CFR 0.152.
 */
package io.github.lukehutch.fastclasspathscanner.scanner;

import io.github.lukehutch.fastclasspathscanner.scanner.ScanResult;
import io.github.lukehutch.fastclasspathscanner.typesignature.TypeSignature;
import io.github.lukehutch.fastclasspathscanner.utils.Parser;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;

public class AnnotationInfo
extends ScanResult.InfoObject
implements Comparable<AnnotationInfo> {
    String annotationName;
    List<AnnotationParamValue> annotationParamValues;
    transient ScanResult scanResult;
    private static final String[] EMPTY_STRING_ARRAY = new String[0];

    AnnotationInfo() {
    }

    @Override
    void setScanResult(ScanResult scanResult) {
        this.scanResult = scanResult;
        if (this.annotationParamValues != null) {
            for (AnnotationParamValue a : this.annotationParamValues) {
                if (a == null) continue;
                a.setScanResult(scanResult);
            }
        }
    }

    public AnnotationInfo(String annotationName, List<AnnotationParamValue> annotationParamValues) {
        this.annotationName = annotationName;
        if (annotationParamValues != null) {
            Collections.sort(annotationParamValues);
        }
        this.annotationParamValues = annotationParamValues;
    }

    void addDefaultValues(List<AnnotationParamValue> defaultAnnotationParamValues) {
        if (defaultAnnotationParamValues != null && !defaultAnnotationParamValues.isEmpty()) {
            if (this.annotationParamValues == null || this.annotationParamValues.isEmpty()) {
                this.annotationParamValues = new ArrayList<AnnotationParamValue>(defaultAnnotationParamValues);
            } else {
                HashMap<String, Object> allParamValues = new HashMap<String, Object>();
                for (AnnotationParamValue annotationParamValue : defaultAnnotationParamValues) {
                    allParamValues.put(annotationParamValue.paramName, annotationParamValue.paramValue.get());
                }
                for (AnnotationParamValue annotationParamValue : this.annotationParamValues) {
                    allParamValues.put(annotationParamValue.paramName, annotationParamValue.paramValue.get());
                }
                this.annotationParamValues.clear();
                for (Map.Entry entry : allParamValues.entrySet()) {
                    this.annotationParamValues.add(new AnnotationParamValue((String)entry.getKey(), entry.getValue()));
                }
            }
        }
        if (this.annotationParamValues != null) {
            Collections.sort(this.annotationParamValues);
        }
    }

    public String getAnnotationName() {
        return this.annotationName;
    }

    public Class<?> getAnnotationType() {
        return this.scanResult.classNameToClassRef(this.annotationName);
    }

    public List<AnnotationParamValue> getAnnotationParamValues() {
        return this.annotationParamValues;
    }

    @Override
    public int compareTo(AnnotationInfo o) {
        int diff = this.annotationName.compareTo(o.annotationName);
        if (diff != 0) {
            return diff;
        }
        if (this.annotationParamValues == null && o.annotationParamValues == null) {
            return 0;
        }
        if (this.annotationParamValues == null) {
            return -1;
        }
        if (o.annotationParamValues == null) {
            return 1;
        }
        int max = Math.max(this.annotationParamValues.size(), o.annotationParamValues.size());
        for (int i = 0; i < max; ++i) {
            if (i >= this.annotationParamValues.size()) {
                return -1;
            }
            if (i >= o.annotationParamValues.size()) {
                return 1;
            }
            int diff2 = this.annotationParamValues.get(i).compareTo(o.annotationParamValues.get(i));
            if (diff2 == 0) continue;
            return diff2;
        }
        return 0;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof AnnotationInfo)) {
            return false;
        }
        AnnotationInfo o = (AnnotationInfo)obj;
        return this.compareTo(o) == 0;
    }

    public int hashCode() {
        int h = this.annotationName.hashCode();
        if (this.annotationParamValues != null) {
            for (int i = 0; i < this.annotationParamValues.size(); ++i) {
                AnnotationParamValue e = this.annotationParamValues.get(i);
                h = h * 7 + e.getParamName().hashCode() * 3 + e.getParamValue().hashCode();
            }
        }
        return h;
    }

    public void toString(StringBuilder buf) {
        buf.append("@" + this.annotationName);
        if (this.annotationParamValues != null) {
            buf.append('(');
            for (int i = 0; i < this.annotationParamValues.size(); ++i) {
                if (i > 0) {
                    buf.append(", ");
                }
                AnnotationParamValue annotationParamValue = this.annotationParamValues.get(i);
                if (this.annotationParamValues.size() > 1 || !"value".equals(annotationParamValue.paramName)) {
                    annotationParamValue.toString(buf);
                    continue;
                }
                annotationParamValue.toStringParamValueOnly(buf);
            }
            buf.append(')');
        }
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        this.toString(buf);
        return buf.toString();
    }

    public static String[] getUniqueAnnotationNamesSorted(Collection<AnnotationInfo> annotationInfo) {
        if (annotationInfo == null || annotationInfo.isEmpty()) {
            return EMPTY_STRING_ARRAY;
        }
        HashSet<String> annotationNamesSet = new HashSet<String>();
        for (AnnotationInfo annotation : annotationInfo) {
            annotationNamesSet.add(annotation.annotationName);
        }
        Object[] annotationNamesSorted = new String[annotationNamesSet.size()];
        int i = 0;
        for (String annotationName : annotationNamesSet) {
            annotationNamesSorted[i++] = annotationName;
        }
        Arrays.sort(annotationNamesSorted);
        return annotationNamesSorted;
    }

    public static String[] getUniqueAnnotationNamesSorted(AnnotationInfo[] annotationInfo) {
        if (annotationInfo == null || annotationInfo.length == 0) {
            return EMPTY_STRING_ARRAY;
        }
        HashSet<String> annotationNamesSet = new HashSet<String>();
        for (AnnotationInfo annotation : annotationInfo) {
            annotationNamesSet.add(annotation.annotationName);
        }
        Object[] annotationNamesSorted = new String[annotationNamesSet.size()];
        int i = 0;
        for (String annotationName : annotationNamesSet) {
            annotationNamesSorted[i++] = annotationName;
        }
        Arrays.sort(annotationNamesSorted);
        return annotationNamesSorted;
    }

    public static class AnnotationClassRef
    extends ScanResult.InfoObject {
        String typeDescriptor;
        transient TypeSignature typeSignature;
        transient ScanResult scanResult;

        AnnotationClassRef() {
        }

        @Override
        void setScanResult(ScanResult scanResult) {
            this.scanResult = scanResult;
        }

        AnnotationClassRef(String classRefTypeDescriptor) {
            this.typeDescriptor = classRefTypeDescriptor;
        }

        public TypeSignature getTypeSignature() {
            if (this.typeSignature == null) {
                try {
                    this.typeSignature = TypeSignature.parse(this.typeDescriptor);
                }
                catch (Parser.ParseException e) {
                    throw new IllegalArgumentException(e);
                }
            }
            return this.typeSignature;
        }

        public Class<?> getType() {
            return this.getTypeSignature().instantiate(this.scanResult);
        }

        public int hashCode() {
            return this.getTypeSignature().hashCode();
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof AnnotationClassRef)) {
                return false;
            }
            return this.getTypeSignature().equals(((AnnotationClassRef)obj).getTypeSignature());
        }

        public String toString() {
            return this.getTypeSignature().toString();
        }
    }

    public static class AnnotationEnumValue
    extends ScanResult.InfoObject
    implements Comparable<AnnotationEnumValue> {
        String className;
        String constName;
        transient ScanResult scanResult;

        AnnotationEnumValue() {
        }

        public AnnotationEnumValue(String className, String constName) {
            this.className = className;
            this.constName = constName;
        }

        @Override
        void setScanResult(ScanResult scanResult) {
            this.scanResult = scanResult;
        }

        public String getClassName() {
            return this.className;
        }

        public String getConstName() {
            return this.constName;
        }

        public Object getEnumValueRef() throws IllegalArgumentException {
            Field field;
            Class<?> classRef = this.scanResult.classNameToClassRef(this.className);
            if (!classRef.isEnum()) {
                throw new IllegalArgumentException("Class " + this.className + " is not an enum");
            }
            try {
                field = classRef.getDeclaredField(this.constName);
            }
            catch (NoSuchFieldException | SecurityException e) {
                throw new IllegalArgumentException("Could not find enum constant " + this.toString(), e);
            }
            if (!field.isEnumConstant()) {
                throw new IllegalArgumentException("Field " + this.toString() + " is not an enum constant");
            }
            try {
                return field.get(null);
            }
            catch (IllegalAccessException e) {
                throw new IllegalArgumentException("Field " + this.toString() + " is not accessible", e);
            }
        }

        @Override
        public int compareTo(AnnotationEnumValue o) {
            int diff = this.className.compareTo(o.className);
            return diff == 0 ? this.constName.compareTo(o.constName) : diff;
        }

        public boolean equals(Object o) {
            if (!(o instanceof AnnotationEnumValue)) {
                return false;
            }
            return this.compareTo((AnnotationEnumValue)o) == 0;
        }

        public int hashCode() {
            return this.className.hashCode() * 11 + this.constName.hashCode();
        }

        public String toString() {
            return this.className + "." + this.constName;
        }
    }

    public static class AnnotationParamValue
    extends ScanResult.InfoObject
    implements Comparable<AnnotationParamValue> {
        String paramName;
        AnnotationParamValueWrapper paramValue;

        AnnotationParamValue() {
        }

        public AnnotationParamValue(String paramName, Object paramValue) {
            this.paramName = paramName;
            this.paramValue = new AnnotationParamValueWrapper(paramValue);
        }

        @Override
        void setScanResult(ScanResult scanResult) {
            if (this.paramValue != null) {
                this.paramValue.setScanResult(scanResult);
            }
        }

        public String getParamName() {
            return this.paramName;
        }

        public Object getParamValue() {
            return this.paramValue == null ? null : this.paramValue.get();
        }

        public String toString() {
            StringBuilder buf = new StringBuilder();
            this.toString(buf);
            return buf.toString();
        }

        void toString(StringBuilder buf) {
            buf.append(this.paramName);
            buf.append(" = ");
            this.toStringParamValueOnly(buf);
        }

        void toStringParamValueOnly(StringBuilder buf) {
            if (this.paramValue == null) {
                buf.append("null");
            } else {
                Object paramVal = this.paramValue.get();
                Class<?> valClass = paramVal.getClass();
                if (valClass.isArray()) {
                    buf.append('{');
                    int n = Array.getLength(paramVal);
                    for (int j = 0; j < n; ++j) {
                        Object elt;
                        if (j > 0) {
                            buf.append(", ");
                        }
                        buf.append((elt = Array.get(paramVal, j)) == null ? "null" : elt.toString());
                    }
                    buf.append('}');
                } else if (paramVal instanceof String) {
                    buf.append('\"');
                    buf.append(paramVal.toString().replace("\"", "\\\"").replace("\n", "\\n").replace("\r", "\\r"));
                    buf.append('\"');
                } else if (paramVal instanceof Character) {
                    buf.append('\'');
                    buf.append(paramVal.toString().replace("'", "\\'").replace("\n", "\\n").replace("\r", "\\r"));
                    buf.append('\'');
                } else {
                    buf.append(paramVal.toString());
                }
            }
        }

        @Override
        public int compareTo(AnnotationParamValue o) {
            int diff = this.paramName.compareTo(o.getParamName());
            if (diff != 0) {
                return diff;
            }
            Object p0 = this.getParamValue();
            Object p1 = o.getParamValue();
            if (p0 == null && p1 == null) {
                return 0;
            }
            if (p0 == null && p1 != null) {
                return -1;
            }
            if (p0 != null && p1 == null) {
                return 1;
            }
            return p0.toString().compareTo(p1.toString());
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof AnnotationParamValue)) {
                return false;
            }
            AnnotationParamValue o = (AnnotationParamValue)obj;
            int diff = this.compareTo(o);
            return diff != 0 ? false : (this.paramValue == null && o.paramValue == null ? true : this.paramValue != null && o.paramValue != null);
        }
    }

    private static class AnnotationParamValueWrapper
    extends ScanResult.InfoObject {
        AnnotationEnumValue annotationEnumValue;
        AnnotationClassRef annotationClassRef;
        AnnotationInfo annotationInfo;
        AnnotationParamValueWrapper[] annotationValueArray;
        String annotationConstantString;
        Integer annotationConstantInteger;
        Long annotationConstantLong;
        Short annotationConstantShort;
        Boolean annotationConstantBoolean;
        Character annotationConstantCharacter;
        Float annotationConstantFloat;
        Double annotationConstantDouble;
        Byte annotationConstantByte;

        public AnnotationParamValueWrapper() {
        }

        public AnnotationParamValueWrapper(Object annotationParamValue) {
            if (annotationParamValue != null) {
                if (annotationParamValue.getClass().isArray()) {
                    int n = Array.getLength(annotationParamValue);
                    this.annotationValueArray = new AnnotationParamValueWrapper[n];
                    for (int i = 0; i < n; ++i) {
                        this.annotationValueArray[i] = new AnnotationParamValueWrapper(Array.get(annotationParamValue, i));
                    }
                } else if (annotationParamValue instanceof AnnotationEnumValue) {
                    this.annotationEnumValue = (AnnotationEnumValue)annotationParamValue;
                } else if (annotationParamValue instanceof AnnotationClassRef) {
                    this.annotationClassRef = (AnnotationClassRef)annotationParamValue;
                } else if (annotationParamValue instanceof AnnotationInfo) {
                    this.annotationInfo = (AnnotationInfo)annotationParamValue;
                } else if (annotationParamValue instanceof String) {
                    this.annotationConstantString = (String)annotationParamValue;
                } else if (annotationParamValue instanceof Integer) {
                    this.annotationConstantInteger = (Integer)annotationParamValue;
                } else if (annotationParamValue instanceof Long) {
                    this.annotationConstantLong = (Long)annotationParamValue;
                } else if (annotationParamValue instanceof Short) {
                    this.annotationConstantShort = (Short)annotationParamValue;
                } else if (annotationParamValue instanceof Boolean) {
                    this.annotationConstantBoolean = (Boolean)annotationParamValue;
                } else if (annotationParamValue instanceof Character) {
                    this.annotationConstantCharacter = (Character)annotationParamValue;
                } else if (annotationParamValue instanceof Float) {
                    this.annotationConstantFloat = (Float)annotationParamValue;
                } else if (annotationParamValue instanceof Double) {
                    this.annotationConstantDouble = (Double)annotationParamValue;
                } else if (annotationParamValue instanceof Byte) {
                    this.annotationConstantByte = (Byte)annotationParamValue;
                } else {
                    throw new IllegalArgumentException("Unsupported annotation parameter value type: " + annotationParamValue.getClass().getName());
                }
            }
        }

        public Object get() {
            if (this.annotationValueArray != null) {
                Object[] annotationValueObjects = new Object[this.annotationValueArray.length];
                for (int i = 0; i < this.annotationValueArray.length; ++i) {
                    if (this.annotationValueArray[i] == null) continue;
                    annotationValueObjects[i] = this.annotationValueArray[i].get();
                }
                return annotationValueObjects;
            }
            if (this.annotationEnumValue != null) {
                return this.annotationEnumValue;
            }
            if (this.annotationClassRef != null) {
                return this.annotationClassRef;
            }
            if (this.annotationInfo != null) {
                return this.annotationInfo;
            }
            if (this.annotationConstantString != null) {
                return this.annotationConstantString;
            }
            if (this.annotationConstantInteger != null) {
                return this.annotationConstantInteger;
            }
            if (this.annotationConstantLong != null) {
                return this.annotationConstantLong;
            }
            if (this.annotationConstantShort != null) {
                return this.annotationConstantShort;
            }
            if (this.annotationConstantBoolean != null) {
                return this.annotationConstantBoolean;
            }
            if (this.annotationConstantCharacter != null) {
                return this.annotationConstantCharacter;
            }
            if (this.annotationConstantFloat != null) {
                return this.annotationConstantFloat;
            }
            if (this.annotationConstantDouble != null) {
                return this.annotationConstantDouble;
            }
            if (this.annotationConstantByte != null) {
                return this.annotationConstantByte;
            }
            return null;
        }

        @Override
        void setScanResult(ScanResult scanResult) {
            if (this.annotationValueArray != null) {
                for (int i = 0; i < this.annotationValueArray.length; ++i) {
                    if (this.annotationValueArray[i] == null) continue;
                    this.annotationValueArray[i].setScanResult(scanResult);
                }
            } else if (this.annotationEnumValue != null) {
                this.annotationEnumValue.setScanResult(scanResult);
            } else if (this.annotationClassRef != null) {
                this.annotationClassRef.setScanResult(scanResult);
            } else if (this.annotationInfo != null) {
                this.annotationInfo.setScanResult(scanResult);
            }
        }
    }
}

