/*
 * Decompiled with CFR 0.152.
 */
package io.github.lukehutch.fastclasspathscanner.typesignature;

import io.github.lukehutch.fastclasspathscanner.typesignature.HierarchicalTypeSignature;
import io.github.lukehutch.fastclasspathscanner.typesignature.ReferenceTypeSignature;
import io.github.lukehutch.fastclasspathscanner.utils.Parser;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;

public class TypeArgument
extends HierarchicalTypeSignature {
    private final WILDCARD wildcard;
    private final ReferenceTypeSignature typeSignature;

    public TypeArgument(WILDCARD wildcard, ReferenceTypeSignature typeSignature) {
        this.wildcard = wildcard;
        this.typeSignature = typeSignature;
    }

    public WILDCARD getWildcard() {
        return this.wildcard;
    }

    public ReferenceTypeSignature getTypeSignature() {
        return this.typeSignature;
    }

    @Override
    public void getAllReferencedClassNames(Set<String> classNameListOut) {
        if (this.typeSignature != null) {
            this.typeSignature.getAllReferencedClassNames(classNameListOut);
        }
    }

    public int hashCode() {
        return this.typeSignature.hashCode() + 7 * this.wildcard.hashCode();
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof TypeArgument)) {
            return false;
        }
        TypeArgument o = (TypeArgument)obj;
        return o.typeSignature.equals(this.typeSignature) && o.wildcard.equals((Object)this.wildcard);
    }

    public String toString() {
        String typeSigStr = this.typeSignature == null ? null : this.typeSignature.toString();
        switch (this.wildcard) {
            case ANY: {
                return "?";
            }
            case EXTENDS: {
                return typeSigStr.equals("java.lang.Object") ? "?" : "? extends " + typeSigStr;
            }
            case SUPER: {
                return "? super " + typeSigStr;
            }
            case NONE: {
                return typeSigStr;
            }
        }
        throw new RuntimeException("Unknown wildcard type");
    }

    static TypeArgument parse(Parser parser) throws Parser.ParseException {
        char peek = parser.peek();
        if (peek == '*') {
            parser.expect('*');
            return new TypeArgument(WILDCARD.ANY, null);
        }
        if (peek == '+') {
            parser.expect('+');
            ReferenceTypeSignature typeSignature = ReferenceTypeSignature.parseReferenceTypeSignature(parser);
            if (typeSignature == null) {
                throw new Parser.ParseException(parser, "Missing '+' type bound");
            }
            return new TypeArgument(WILDCARD.EXTENDS, typeSignature);
        }
        if (peek == '-') {
            parser.expect('-');
            ReferenceTypeSignature typeSignature = ReferenceTypeSignature.parseReferenceTypeSignature(parser);
            if (typeSignature == null) {
                throw new Parser.ParseException(parser, "Missing '-' type bound");
            }
            return new TypeArgument(WILDCARD.SUPER, typeSignature);
        }
        ReferenceTypeSignature typeSignature = ReferenceTypeSignature.parseReferenceTypeSignature(parser);
        if (typeSignature == null) {
            throw new Parser.ParseException(parser, "Missing type bound");
        }
        return new TypeArgument(WILDCARD.NONE, typeSignature);
    }

    static List<TypeArgument> parseList(Parser parser) throws Parser.ParseException {
        if (parser.peek() == '<') {
            parser.expect('<');
            ArrayList<TypeArgument> typeArguments = new ArrayList<TypeArgument>(2);
            while (parser.peek() != '>') {
                if (!parser.hasMore()) {
                    throw new Parser.ParseException(parser, "Missing '>'");
                }
                typeArguments.add(TypeArgument.parse(parser));
            }
            parser.expect('>');
            return typeArguments;
        }
        return Collections.emptyList();
    }

    public static enum WILDCARD {
        NONE,
        ANY,
        EXTENDS,
        SUPER;

    }
}

