/*
 * Decompiled with CFR 0.152.
 */
package io.github.lukehutch.fastclasspathscanner.typesignature;

import io.github.lukehutch.fastclasspathscanner.utils.Parser;

public class TypeUtils {
    public static final int MODIFIER_SYNTHETIC = 4096;
    public static final int MODIFIER_MANDATED = 32768;

    public static String modifiersToString(int modifiers, boolean isMethod) {
        StringBuilder buf = new StringBuilder();
        TypeUtils.modifiersToString(modifiers, isMethod, buf);
        return buf.toString();
    }

    public static void modifiersToString(int modifiers, boolean isMethod, StringBuilder buf) {
        if ((modifiers & 1) != 0) {
            buf.append("public");
        } else if ((modifiers & 4) != 0) {
            buf.append("protected");
        } else if ((modifiers & 2) != 0) {
            buf.append("private");
        }
        if ((modifiers & 0x400) != 0) {
            if (buf.length() > 0) {
                buf.append(' ');
            }
            buf.append("abstract");
        }
        if ((modifiers & 8) != 0) {
            if (buf.length() > 0) {
                buf.append(' ');
            }
            buf.append("static");
        }
        if ((modifiers & 0x10) != 0) {
            if (buf.length() > 0) {
                buf.append(' ');
            }
            buf.append("final");
        }
        if (!isMethod && (modifiers & 0x80) != 0) {
            if (buf.length() > 0) {
                buf.append(' ');
            }
            buf.append("transient");
        } else if ((modifiers & 0x40) != 0) {
            if (buf.length() > 0) {
                buf.append(' ');
            }
            if (!isMethod) {
                buf.append("volatile");
            } else {
                buf.append("bridge");
            }
        }
        if (!isMethod && (modifiers & 0x1000) != 0) {
            if (buf.length() > 0) {
                buf.append(' ');
            }
            buf.append("synthetic");
        }
        if ((modifiers & 0x20) != 0) {
            if (buf.length() > 0) {
                buf.append(' ');
            }
            buf.append("synchronized");
        }
        if ((modifiers & 0x100) != 0) {
            if (buf.length() > 0) {
                buf.append(' ');
            }
            buf.append("native");
        }
        if ((modifiers & 0x800) != 0) {
            if (buf.length() > 0) {
                buf.append(' ');
            }
            buf.append("strictfp");
        }
    }

    public static boolean getIdentifierToken(Parser parser, char separator, char separatorReplace) throws Parser.ParseException {
        boolean consumedChar = false;
        while (parser.hasMore()) {
            char c = parser.peek();
            if (c == separator) {
                parser.appendToToken(separatorReplace);
                parser.next();
                consumedChar = true;
                continue;
            }
            if (c == ';' || c == '[' || c == '<' || c == '>' || c == ':' || c == '/' || c == '.') break;
            parser.appendToToken(c);
            parser.next();
            consumedChar = true;
        }
        return consumedChar;
    }

    public static boolean getIdentifierToken(Parser parser) throws Parser.ParseException {
        return TypeUtils.getIdentifierToken(parser, '\u0000', '\u0000');
    }
}

