/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.sitegen;

import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public abstract class AbstractBuilder<T> {
    private final Map<String, Object> attributes = new HashMap<String, Object>();

    protected void put(String key, Object val) {
        this.attributes.put(key, val);
    }

    protected Collection<Map.Entry<String, Object>> values() {
        return this.attributes.entrySet();
    }

    protected static <T> T asType(Object object, Class<T> clazz) throws IllegalStateException {
        try {
            return (T)object;
        }
        catch (ClassCastException ex) {
            throw new IllegalStateException(ex);
        }
    }

    protected static <U, V> Map<U, V> asMap(Object object, Class<U> keyClass, Class<V> valueClass) throws IllegalStateException {
        try {
            return (Map)object;
        }
        catch (ClassCastException ex) {
            throw new IllegalStateException(ex);
        }
    }

    protected static <U> List<U> asList(Object object, Class<U> eltClass) throws IllegalStateException {
        try {
            return (List)object;
        }
        catch (ClassCastException ex) {
            throw new IllegalStateException(ex);
        }
    }

    public abstract T build();
}

