/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.sitegen;

import io.helidon.config.Config;
import io.helidon.sitegen.AbstractBuilder;
import io.helidon.sitegen.Helper;
import io.helidon.sitegen.Model;
import java.util.Map;

public class Glyph
implements Model {
    private static final String TYPE_PROP = "type";
    private static final String VALUE_PROP = "value";
    private final String type;
    private final String value;

    private Glyph(String type, String value) {
        Helper.checkNonNullNonEmpty(type, TYPE_PROP);
        Helper.checkNonNullNonEmpty(value, VALUE_PROP);
        this.type = type;
        this.value = value;
    }

    public String getType() {
        return this.type;
    }

    public String getValue() {
        return this.value;
    }

    @Override
    public Object get(String attr) {
        switch (attr) {
            case "type": {
                return this.type;
            }
            case "value": {
                return this.value;
            }
        }
        throw new IllegalArgumentException("Unkown attribute: " + attr);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder
    extends AbstractBuilder<Glyph> {
        public Builder type(String type) {
            this.put(Glyph.TYPE_PROP, type);
            return this;
        }

        public Builder value(String value) {
            this.put(Glyph.VALUE_PROP, value);
            return this;
        }

        public Builder config(Config node) {
            if (node.exists()) {
                node.get(Glyph.TYPE_PROP).ifExists(c -> this.put(Glyph.TYPE_PROP, c.asString()));
                node.get(Glyph.VALUE_PROP).ifExists(c -> this.put(Glyph.VALUE_PROP, c.asString()));
            }
            return this;
        }

        @Override
        public Glyph build() {
            String type = null;
            String value = null;
            block8: for (Map.Entry<String, Object> entry : this.values()) {
                String attr = entry.getKey();
                Object val = entry.getValue();
                switch (attr) {
                    case "type": {
                        type = Builder.asType(val, String.class);
                        continue block8;
                    }
                    case "value": {
                        value = Builder.asType(val, String.class);
                        continue block8;
                    }
                }
                throw new IllegalStateException("Unkown attribute: " + attr);
            }
            return new Glyph(type, value);
        }
    }
}

