/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.sitegen;

import io.helidon.config.Config;
import io.helidon.sitegen.AbstractBuilder;
import io.helidon.sitegen.Model;
import io.helidon.sitegen.WebResource;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class Header
implements Model {
    private static final String FAVICON_PROP = "favicon";
    private static final String STYLESHEETS_PROP = "stylesheets";
    private static final String SCRIPTS_PROP = "scripts";
    private static final String META_PROP = "meta";
    private final WebResource favicon;
    private final List<WebResource> stylesheets;
    private final List<WebResource> scripts;
    private final Map<String, String> meta;

    Header() {
        this.favicon = null;
        this.stylesheets = Collections.emptyList();
        this.scripts = Collections.emptyList();
        this.meta = Collections.emptyMap();
    }

    private Header(WebResource favicon, List<WebResource> stylesheets, List<WebResource> scripts, Map<String, String> meta) {
        this.favicon = favicon;
        this.stylesheets = stylesheets == null ? Collections.emptyList() : stylesheets;
        this.scripts = scripts == null ? Collections.emptyList() : scripts;
        this.meta = meta == null ? Collections.emptyMap() : meta;
    }

    public WebResource getFavicon() {
        return this.favicon;
    }

    public List<WebResource> getStylesheets() {
        return this.stylesheets;
    }

    public List<WebResource> getScripts() {
        return this.scripts;
    }

    public Map<String, String> getMeta() {
        return this.meta;
    }

    @Override
    public Object get(String attr) {
        switch (attr) {
            case "favicon": {
                return this.favicon;
            }
            case "stylesheets": {
                return this.stylesheets;
            }
            case "scripts": {
                return this.scripts;
            }
            case "meta": {
                return this.meta;
            }
        }
        throw new IllegalArgumentException("Unkown attribute: " + attr);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder
    extends AbstractBuilder<Header> {
        public Builder favicon(WebResource favicon) {
            this.put(Header.FAVICON_PROP, favicon);
            return this;
        }

        public Builder stylesheets(List<WebResource> stylesheets) {
            this.put(Header.STYLESHEETS_PROP, stylesheets);
            return this;
        }

        public Builder scripts(List<WebResource> scripts) {
            this.put(Header.SCRIPTS_PROP, scripts);
            return this;
        }

        public Builder meta(Map<String, String> meta) {
            this.put(Header.META_PROP, meta);
            return this;
        }

        public Builder config(Config node) {
            if (node.exists()) {
                node.get(Header.FAVICON_PROP).ifExists(c -> this.put(Header.FAVICON_PROP, WebResource.builder().config((Config)c).build()));
                node.get(Header.STYLESHEETS_PROP).asOptionalNodeList().ifPresent(nodeList -> this.put(Header.STYLESHEETS_PROP, nodeList.stream().map(c -> WebResource.builder().config((Config)c).build()).collect(Collectors.toList())));
                node.get(Header.SCRIPTS_PROP).asOptionalNodeList().ifPresent(nodeList -> this.put(Header.SCRIPTS_PROP, nodeList.stream().map(c -> WebResource.builder().config((Config)c).build()).collect(Collectors.toList())));
                node.get(Header.META_PROP).detach().asOptionalMap().ifPresent(m -> this.put(Header.META_PROP, m));
            }
            return this;
        }

        @Override
        public Header build() {
            WebResource favicon = null;
            List<WebResource> stylesheets = null;
            List<WebResource> scripts = null;
            Map<String, String> meta = null;
            block12: for (Map.Entry<String, Object> entry : this.values()) {
                String attr = entry.getKey();
                Object val = entry.getValue();
                switch (attr) {
                    case "favicon": {
                        favicon = Builder.asType(val, WebResource.class);
                        continue block12;
                    }
                    case "stylesheets": {
                        stylesheets = Builder.asList(val, WebResource.class);
                        continue block12;
                    }
                    case "scripts": {
                        scripts = Builder.asList(val, WebResource.class);
                        continue block12;
                    }
                    case "meta": {
                        meta = Builder.asMap(val, String.class, String.class);
                        continue block12;
                    }
                }
                throw new IllegalStateException("Unkown attribute: " + attr);
            }
            return new Header(favicon, stylesheets, scripts, meta);
        }
    }
}

