/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.sitegen;

import io.helidon.sitegen.Helper;
import io.helidon.sitegen.Page;
import io.helidon.sitegen.PageRenderer;
import io.helidon.sitegen.RenderingException;
import io.helidon.sitegen.Site;
import io.helidon.sitegen.SourcePath;
import io.helidon.sitegen.StaticAsset;
import io.helidon.sitegen.freemarker.TemplateSession;
import java.io.File;
import java.io.IOException;
import java.util.List;
import java.util.Map;

public class RenderingContext {
    private final Site site;
    private final TemplateSession templateSession;
    private final Map<String, Page> pages;
    private final File sourcedir;
    private final File outputdir;
    private final List<SourcePath> sourcePaths;

    RenderingContext(Site site, File sourcedir, File outputdir) {
        Helper.checkNonNull(site, "site");
        Helper.checkValidDir(sourcedir, "sourcedir");
        Helper.checkNonNull(outputdir, "outputdir");
        this.site = site;
        this.sourcedir = sourcedir;
        this.outputdir = outputdir;
        this.templateSession = new TemplateSession();
        this.sourcePaths = SourcePath.scan(sourcedir);
        this.pages = Page.create(this.sourcePaths, site.getPages(), sourcedir, site.getBackend());
    }

    public File getSourcedir() {
        return this.sourcedir;
    }

    public File getOutputdir() {
        return this.outputdir;
    }

    public TemplateSession getTemplateSession() {
        return this.templateSession;
    }

    public Map<String, Page> getPages() {
        return this.pages;
    }

    public Site getSite() {
        return this.site;
    }

    public Page getPageForRoute(String route) {
        Helper.checkNonNullNonEmpty(route, "route");
        for (Page page : this.pages.values()) {
            if (!route.equals(page.getTargetPath())) continue;
            return page;
        }
        return null;
    }

    public void copyStaticAssets() {
        for (StaticAsset asset : this.site.getAssets()) {
            for (SourcePath path : SourcePath.filter(this.sourcePaths, asset.getIncludes(), asset.getExcludes())) {
                File targetDir = new File(this.outputdir, asset.getTarget());
                targetDir.mkdirs();
                try {
                    Helper.copyResources(new File(this.sourcedir, path.asString()).toPath(), new File(targetDir, path.asString()));
                }
                catch (IOException ex) {
                    throw new RenderingException("An error occurred while copying resource: " + path.asString(), ex);
                }
            }
        }
    }

    public void processPages(File pagesdir, String ext) {
        for (Page page : this.pages.values()) {
            PageRenderer renderer = this.site.getBackend().getPageRenderer(page.getSourceExt());
            renderer.process(page, this, pagesdir, ext);
        }
    }
}

