/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.sitegen;

import io.helidon.config.Config;
import io.helidon.config.ConfigFilters;
import io.helidon.config.ConfigMappers;
import io.helidon.config.ConfigSources;
import io.helidon.sitegen.AbstractBuilder;
import io.helidon.sitegen.Backend;
import io.helidon.sitegen.BasicBackend;
import io.helidon.sitegen.Header;
import io.helidon.sitegen.Helper;
import io.helidon.sitegen.RenderingContext;
import io.helidon.sitegen.RenderingException;
import io.helidon.sitegen.SiteEngine;
import io.helidon.sitegen.SourcePathFilter;
import io.helidon.sitegen.StaticAsset;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.function.Supplier;
import java.util.stream.Collectors;

public class Site {
    private static final String ENGINE_PROP = "engine";
    private static final String ASSETS_PROP = "assets";
    private static final String HEADER_PROP = "header";
    private static final String PAGES_PROP = "pages";
    private static final String BACKEND_PROP = "backend";
    public static final ThreadLocal<String> THREADLOCAL = new ThreadLocal();
    private final SiteEngine engine;
    private final List<StaticAsset> assets;
    private final Header header;
    private final List<SourcePathFilter> pages;
    private final Backend backend;

    private Site(SiteEngine engine, List<StaticAsset> assets, Header header, List<SourcePathFilter> pages, Backend backend) {
        this.backend = backend == null ? new BasicBackend() : backend;
        String backendName = this.backend.getName();
        THREADLOCAL.set(backendName);
        this.engine = engine == null ? SiteEngine.builder().build() : engine;
        this.assets = assets == null ? Collections.emptyList() : assets;
        this.header = header == null ? new Header() : header;
        this.pages = pages == null ? Collections.emptyList() : pages;
        SiteEngine.register(backendName, this.engine);
    }

    public SiteEngine getEngine() {
        return this.engine;
    }

    public List<StaticAsset> getAssets() {
        return this.assets;
    }

    public Header getHeader() {
        return this.header;
    }

    public List<SourcePathFilter> getPages() {
        return this.pages;
    }

    public Backend getBackend() {
        return this.backend;
    }

    public void generate(File sourcedir, File outputdir) throws RenderingException {
        try {
            Files.createDirectories(outputdir.toPath(), new FileAttribute[0]);
        }
        catch (IOException ex) {
            throw new RenderingException(ex.getMessage(), ex);
        }
        this.backend.generate(new RenderingContext(this, sourcedir, outputdir));
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder
    extends AbstractBuilder<Site> {
        public Builder config(File configFile) {
            return this.config(configFile, new Properties());
        }

        public Builder config(File configFile, Properties properties) {
            Config config = Config.builder().addFilter((Supplier)ConfigFilters.valueResolving()).addMapper(Properties.class, c -> ConfigMappers.toProperties((Config)c.detach())).sources((Supplier)ConfigSources.file((String)configFile.getAbsolutePath()), (Supplier)ConfigSources.from((Properties)properties)).build();
            config.get(Site.BACKEND_PROP).ifExistsOrElse(c -> {
                Object backend = Backend.builder().config((Config)c).build();
                this.put(Site.BACKEND_PROP, backend);
                THREADLOCAL.set(((Backend)backend).getName());
            }, () -> {
                BasicBackend backend = new BasicBackend();
                this.put(Site.BACKEND_PROP, backend);
                THREADLOCAL.set(backend.getName());
            });
            config.get(Site.ENGINE_PROP).ifExists(c -> this.put(Site.ENGINE_PROP, SiteEngine.builder().config((Config)c).build()));
            config.get(Site.ASSETS_PROP).ifExists(c -> this.put(Site.ASSETS_PROP, c.asNodeList().stream().map(n -> StaticAsset.builder().config((Config)n).build()).collect(Collectors.toList())));
            config.get(Site.HEADER_PROP).ifExists(c -> this.put(Site.HEADER_PROP, Header.builder().config((Config)c).build()));
            config.get(Site.PAGES_PROP).ifExists(c -> this.put(Site.PAGES_PROP, c.asNodeList().stream().map(n -> SourcePathFilter.builder().config((Config)n).build()).collect(Collectors.toList())));
            return this;
        }

        public Builder pages(List<SourcePathFilter> pages) {
            this.put(Site.PAGES_PROP, pages);
            return this;
        }

        public Builder engine(SiteEngine engine) {
            this.put(Site.ENGINE_PROP, engine);
            return this;
        }

        public Builder backend(Backend backend) {
            Helper.checkNonNull(backend, Site.BACKEND_PROP);
            this.put(Site.BACKEND_PROP, backend);
            THREADLOCAL.set(backend.getName());
            return this;
        }

        public Builder header(Header header) {
            this.put(Site.HEADER_PROP, header);
            return this;
        }

        public Builder assets(List<StaticAsset> assets) {
            this.put(Site.ASSETS_PROP, assets);
            return this;
        }

        @Override
        public Site build() {
            SiteEngine engine = null;
            List<StaticAsset> assets = null;
            Header header = null;
            List<SourcePathFilter> pages = null;
            Backend backend = null;
            block14: for (Map.Entry<String, Object> entry : this.values()) {
                String attr = entry.getKey();
                Object val = entry.getValue();
                switch (attr) {
                    case "engine": {
                        engine = Builder.asType(val, SiteEngine.class);
                        continue block14;
                    }
                    case "assets": {
                        assets = Builder.asList(val, StaticAsset.class);
                        continue block14;
                    }
                    case "header": {
                        header = Builder.asType(val, Header.class);
                        continue block14;
                    }
                    case "pages": {
                        pages = Builder.asList(val, SourcePathFilter.class);
                        continue block14;
                    }
                    case "backend": {
                        backend = Builder.asType(val, Backend.class);
                        continue block14;
                    }
                }
                throw new IllegalStateException("Unkown attribute: " + attr);
            }
            return new Site(engine, assets, header, pages, backend);
        }
    }
}

