/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.sitegen;

import io.helidon.config.Config;
import io.helidon.sitegen.AbstractBuilder;
import io.helidon.sitegen.Helper;
import io.helidon.sitegen.asciidoctor.AsciidocEngine;
import io.helidon.sitegen.freemarker.FreemarkerEngine;
import java.util.HashMap;
import java.util.Map;

public class SiteEngine {
    private static final Map<String, SiteEngine> REGISTRY = new HashMap<String, SiteEngine>();
    private static final String FREEMARKER_PROP = "freemarker";
    private static final String ASCIIDOCTOR_PROP = "asciidoctor";
    private static final String BACKEND_PROP = "backend";
    private final AsciidocEngine asciidoc;
    private final FreemarkerEngine freemarker;

    public SiteEngine(FreemarkerEngine freemarker, AsciidocEngine asciidoc) {
        this.freemarker = freemarker == null ? FreemarkerEngine.builder().build() : freemarker;
        this.asciidoc = asciidoc == null ? AsciidocEngine.builder().build() : asciidoc;
    }

    public AsciidocEngine asciidoc() {
        return this.asciidoc;
    }

    public FreemarkerEngine freemarker() {
        return this.freemarker;
    }

    public static void register(String backend, SiteEngine engine) {
        Helper.checkNonNullNonEmpty(backend, BACKEND_PROP);
        REGISTRY.put(backend, engine);
    }

    public static void deregister(String backend) {
        Helper.checkNonNullNonEmpty(backend, BACKEND_PROP);
        REGISTRY.remove(backend);
    }

    public static SiteEngine get(String backend) {
        SiteEngine siteEngine = REGISTRY.get(backend);
        if (siteEngine == null) {
            throw new IllegalArgumentException("no site engine found for backend: " + backend);
        }
        return siteEngine;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder
    extends AbstractBuilder<SiteEngine> {
        public Builder freemarker(FreemarkerEngine freemarker) {
            this.put(SiteEngine.FREEMARKER_PROP, freemarker);
            return this;
        }

        public Builder asciidoctor(AsciidocEngine asciidoctor) {
            this.put(SiteEngine.ASCIIDOCTOR_PROP, asciidoctor);
            return this;
        }

        public Builder config(Config node) {
            if (node.exists()) {
                node.get(SiteEngine.FREEMARKER_PROP).ifExists(c -> this.put(SiteEngine.FREEMARKER_PROP, FreemarkerEngine.builder().config((Config)c).build()));
                node.get(SiteEngine.ASCIIDOCTOR_PROP).ifExists(c -> this.put(SiteEngine.ASCIIDOCTOR_PROP, AsciidocEngine.builder().config((Config)c).build()));
            }
            return this;
        }

        @Override
        public SiteEngine build() {
            FreemarkerEngine freemarker = null;
            AsciidocEngine asciidoctor = null;
            block8: for (Map.Entry<String, Object> entry : this.values()) {
                String attr = entry.getKey();
                Object val = entry.getValue();
                switch (attr) {
                    case "freemarker": {
                        freemarker = Builder.asType(val, FreemarkerEngine.class);
                        continue block8;
                    }
                    case "asciidoctor": {
                        asciidoctor = Builder.asType(val, AsciidocEngine.class);
                        continue block8;
                    }
                }
                throw new IllegalStateException("Unkown attribute: " + attr);
            }
            return new SiteEngine(freemarker, asciidoctor);
        }
    }
}

