/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.sitegen;

import io.helidon.config.Config;
import io.helidon.sitegen.AbstractBuilder;
import io.helidon.sitegen.Glyph;
import io.helidon.sitegen.Helper;
import io.helidon.sitegen.Model;
import io.helidon.sitegen.Page;
import io.helidon.sitegen.SourcePathFilter;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class VuetifyNavigation
implements Model {
    private static final String GLYPH_PROP = "glyph";
    private static final String TITLE_PROP = "title";
    private static final String ITEMS_PROP = "items";
    private static final String PATHPREFIX_PROP = "pathprefix";
    private static final String HREF_PROP = "href";
    private static final String INCLUDES_PROP = "includes";
    private static final String EXCLUDES_PROP = "excludes";
    private final List<Item> items;
    private final Glyph glyph;
    private final String title;

    private VuetifyNavigation(String title, Glyph glyph, List<Item> items) {
        Helper.checkNonNullNonEmpty(title, TITLE_PROP);
        Helper.checkNonNull(items, ITEMS_PROP);
        this.glyph = glyph;
        this.items = items;
        this.title = title;
    }

    public List<Item> getItems() {
        return this.items;
    }

    public Glyph getGlyph() {
        return this.glyph;
    }

    public String getTitle() {
        return this.title;
    }

    VuetifyNavigation resolve(Collection<Page> allPages) {
        Builder navigationBuilder = VuetifyNavigation.builder();
        navigationBuilder.title(this.title);
        if (this.glyph != null) {
            navigationBuilder.glyph(this.glyph);
        }
        LinkedList<Item> resolvedGroups = new LinkedList<Item>();
        for (Item group : this.items) {
            if (!(group instanceof Group)) {
                throw new IllegalStateException("top level items is not a group");
            }
            resolvedGroups.add(((Group)group).resolve(allPages));
        }
        navigationBuilder.items(resolvedGroups);
        return navigationBuilder.build();
    }

    @Override
    public Object get(String attr) {
        switch (attr) {
            case "title": {
                return this.title;
            }
            case "glyph": {
                return this.glyph;
            }
            case "items": {
                return this.items;
            }
        }
        throw new IllegalArgumentException("Unkown attribute: " + attr);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Link
    extends Item {
        private final String href;

        private Link(String title, Glyph glyph, String href) {
            super(title, glyph);
            Helper.checkNonNullNonEmpty(href, VuetifyNavigation.HREF_PROP);
            this.href = href;
        }

        public String getHref() {
            return this.href;
        }

        @Override
        public Object get(String attr) {
            switch (attr) {
                case "href": {
                    return this.href;
                }
            }
            return super.get(attr);
        }

        public static Builder builder() {
            return new Builder();
        }

        public static class Builder
        extends Item.Builder<Link> {
            public Builder href(String href) {
                this.put(VuetifyNavigation.HREF_PROP, href);
                return this;
            }

            public Builder config(Config node) {
                super.config(node);
                if (node.exists()) {
                    node.get(VuetifyNavigation.HREF_PROP).ifExists(c -> this.put(VuetifyNavigation.HREF_PROP, c.asString()));
                }
                return this;
            }

            @Override
            public Link build() {
                String title = null;
                Glyph glyph = null;
                String href = null;
                block10: for (Map.Entry<String, Object> entry : this.values()) {
                    String attr = entry.getKey();
                    Object val = entry.getValue();
                    switch (attr) {
                        case "title": {
                            title = Builder.asType(val, String.class);
                            continue block10;
                        }
                        case "glyph": {
                            glyph = Builder.asType(val, Glyph.class);
                            continue block10;
                        }
                        case "href": {
                            href = Builder.asType(val, String.class);
                            continue block10;
                        }
                    }
                    throw new IllegalStateException("Unkown attribute: " + attr);
                }
                return new Link(title, glyph, href);
            }
        }
    }

    public static class SubGroup
    extends Group {
        private final String pathprefix;

        private SubGroup(String title, Glyph glyph, String pathprefix, List<Item> items) {
            super(title, glyph, items);
            Helper.checkNonNullNonEmpty(pathprefix, VuetifyNavigation.PATHPREFIX_PROP);
            this.pathprefix = pathprefix;
        }

        public String getPathprefix() {
            return this.pathprefix;
        }

        private SubGroup resolve(Collection<Page> allPages) {
            Builder subGroupBuilder = SubGroup.builder();
            subGroupBuilder.title(this.getTitle());
            if (this.getGlyph() != null) {
                subGroupBuilder.glyph(this.getGlyph());
            }
            subGroupBuilder.pathprefix(this.pathprefix);
            subGroupBuilder.items(this.getItems().stream().flatMap(item -> {
                if (item instanceof Pages) {
                    return ((Pages)item).resolve(allPages).stream();
                }
                return Stream.of(item);
            }).collect(Collectors.toList()));
            return subGroupBuilder.build();
        }

        @Override
        public Object get(String attr) {
            switch (attr) {
                case "pathprefix": {
                    return this.pathprefix;
                }
            }
            return super.get(attr);
        }

        public static Builder builder() {
            return new Builder();
        }

        public static class Builder
        extends Group.Builder {
            public Builder pathprefix(String pathprefix) {
                this.put(VuetifyNavigation.PATHPREFIX_PROP, pathprefix);
                return this;
            }

            @Override
            public Builder config(Config node) {
                super.config(node);
                if (node.exists()) {
                    node.get(VuetifyNavigation.PATHPREFIX_PROP).ifExists(c -> this.put(VuetifyNavigation.PATHPREFIX_PROP, c.asString()));
                }
                return this;
            }

            @Override
            public SubGroup build() {
                String title = null;
                Glyph glyph = null;
                String pathprefix = null;
                List<Item> items = null;
                block12: for (Map.Entry<String, Object> entry : this.values()) {
                    String attr = entry.getKey();
                    Object val = entry.getValue();
                    switch (attr) {
                        case "title": {
                            title = Builder.asType(val, String.class);
                            continue block12;
                        }
                        case "glyph": {
                            glyph = Builder.asType(val, Glyph.class);
                            continue block12;
                        }
                        case "pathprefix": {
                            pathprefix = Builder.asType(val, String.class);
                            continue block12;
                        }
                        case "items": {
                            items = Builder.asList(val, Item.class);
                            continue block12;
                        }
                    }
                    throw new IllegalStateException("Unkown attribute: " + attr);
                }
                return new SubGroup(title, glyph, pathprefix, items);
            }
        }
    }

    public static class Group
    extends Item {
        private final List<Item> items;

        protected Group(String title, Glyph glyph, List<Item> items) {
            super(title, glyph);
            Helper.checkNonNull(items, VuetifyNavigation.ITEMS_PROP);
            this.items = items;
        }

        public Group(String title, List<Item> items) {
            this(title, null, items);
        }

        public List<Item> getItems() {
            return this.items;
        }

        private Group resolve(Collection<Page> allPages) {
            Builder groupBuilder = Group.builder();
            groupBuilder.title(this.getTitle());
            if (this.getGlyph() != null) {
                groupBuilder.glyph(this.getGlyph());
            }
            groupBuilder.items(this.items.stream().flatMap(item -> {
                if (item instanceof Pages) {
                    return ((Pages)item).resolve(allPages).stream();
                }
                if (item instanceof SubGroup) {
                    return Stream.of(((SubGroup)item).resolve(allPages));
                }
                return Stream.of(item);
            }).collect(Collectors.toList()));
            return groupBuilder.build();
        }

        @Override
        public Object get(String attr) {
            switch (attr) {
                case "items": {
                    return this.items;
                }
            }
            return super.get(attr);
        }

        public static Builder builder() {
            return new Builder();
        }

        public static class Builder
        extends Item.Builder<Group> {
            public Builder items(List<Item> items) {
                this.put(VuetifyNavigation.ITEMS_PROP, items);
                return this;
            }

            public Builder config(Config node) {
                super.config(node);
                if (node.exists()) {
                    node.get(VuetifyNavigation.ITEMS_PROP).ifExists(c -> this.put(VuetifyNavigation.ITEMS_PROP, c.asNodeList().stream().map(n -> Item.from(n)).collect(Collectors.toList())));
                }
                return this;
            }

            @Override
            public Group build() {
                String title = null;
                Glyph glyph = null;
                List<Item> items = null;
                block10: for (Map.Entry<String, Object> entry : this.values()) {
                    String attr = entry.getKey();
                    Object val = entry.getValue();
                    switch (attr) {
                        case "title": {
                            title = Builder.asType(val, String.class);
                            continue block10;
                        }
                        case "glyph": {
                            glyph = Builder.asType(val, Glyph.class);
                            continue block10;
                        }
                        case "items": {
                            items = Builder.asList(val, Item.class);
                            continue block10;
                        }
                    }
                    throw new IllegalStateException("Unkown attribute: " + attr);
                }
                return new Group(title, glyph, items);
            }
        }
    }

    public static class Pages
    extends Item {
        private final SourcePathFilter pages;

        private Pages(SourcePathFilter pages) {
            super(null, null);
            this.pages = pages;
        }

        private List<Item> resolve(Collection<Page> allPages) {
            return Page.filter(allPages, this.pages.getIncludes(), this.pages.getExcludes()).stream().map(page -> (Link)Link.builder().href(page.getTargetPath()).title(page.getMetadata().getTitle()).build()).collect(Collectors.toList());
        }

        public static Builder builder() {
            return new Builder();
        }

        public static class Builder
        extends Item.Builder<Pages> {
            public Builder includes(List<String> includes) {
                this.put(VuetifyNavigation.INCLUDES_PROP, includes);
                return this;
            }

            public Builder excludes(List<String> excludes) {
                this.put(VuetifyNavigation.EXCLUDES_PROP, excludes);
                return this;
            }

            public Builder config(Config node) {
                if (node.exists()) {
                    node.get(VuetifyNavigation.INCLUDES_PROP).ifExists(c -> this.put(VuetifyNavigation.INCLUDES_PROP, c.asStringList()));
                    node.get(VuetifyNavigation.EXCLUDES_PROP).ifExists(c -> this.put(VuetifyNavigation.EXCLUDES_PROP, c.asStringList()));
                }
                return this;
            }

            @Override
            public Pages build() {
                List<String> includes = null;
                List<String> excludes = null;
                block8: for (Map.Entry<String, Object> entry : this.values()) {
                    String attr = entry.getKey();
                    Object val = entry.getValue();
                    switch (attr) {
                        case "includes": {
                            includes = Builder.asList(val, String.class);
                            continue block8;
                        }
                        case "excludes": {
                            excludes = Builder.asList(val, String.class);
                            continue block8;
                        }
                    }
                    throw new IllegalStateException("Unkown attribute: " + attr);
                }
                return new Pages(SourcePathFilter.builder().includes(includes).excludes(excludes).build());
            }
        }
    }

    public static abstract class Item
    implements Model {
        private final String title;
        private final Glyph glyph;

        protected Item(String title, Glyph glyph) {
            this.glyph = glyph;
            this.title = title;
        }

        public String getTitle() {
            return this.title;
        }

        public Glyph getGlyph() {
            return this.glyph;
        }

        public boolean isGroup() {
            return this instanceof Group;
        }

        public Group asGroup() throws IllegalStateException {
            if (!this.isGroup()) {
                throw new IllegalStateException("not a group: " + this);
            }
            return (Group)this;
        }

        public boolean isSubGroup() {
            return this instanceof SubGroup;
        }

        public SubGroup asSubGroup() {
            if (!this.isGroup()) {
                throw new IllegalStateException("not a subgroup: " + this);
            }
            return (SubGroup)this;
        }

        public boolean isLink() {
            return this instanceof Link;
        }

        public Link asLink() {
            if (!this.isLink()) {
                throw new IllegalStateException("not a link: " + this);
            }
            return (Link)this;
        }

        @Override
        public Object get(String attr) {
            switch (attr) {
                case "title": {
                    return this.title;
                }
                case "glyph": {
                    return this.glyph;
                }
                case "isgroup": {
                    return this.isGroup();
                }
                case "islink": {
                    return this.isLink();
                }
            }
            throw new IllegalArgumentException("Unkown attribute: " + attr);
        }

        private static Item from(Config node) {
            if (node.get(VuetifyNavigation.ITEMS_PROP).exists()) {
                if (node.get(VuetifyNavigation.PATHPREFIX_PROP).exists()) {
                    return SubGroup.builder().config(node).build();
                }
                return Group.builder().config(node).build();
            }
            if (node.get(VuetifyNavigation.HREF_PROP).exists()) {
                return Link.builder().config(node).build();
            }
            if (node.get(VuetifyNavigation.INCLUDES_PROP).exists() || node.get(VuetifyNavigation.EXCLUDES_PROP).exists()) {
                return new Pages(SourcePathFilter.builder().config(node).build());
            }
            throw new IllegalArgumentException("Unkown navigation item type");
        }

        protected static abstract class Builder<T extends Item>
        extends AbstractBuilder<T> {
            protected Builder() {
            }

            public Builder<T> title(String title) {
                this.put(VuetifyNavigation.TITLE_PROP, title);
                return this;
            }

            public Builder<T> glyph(Glyph glyph) {
                this.put(VuetifyNavigation.GLYPH_PROP, glyph);
                return this;
            }

            public Builder<T> config(Config node) {
                if (node.exists()) {
                    node.get(VuetifyNavigation.TITLE_PROP).ifExists(c -> this.put(VuetifyNavigation.TITLE_PROP, c.asString()));
                    node.get(VuetifyNavigation.GLYPH_PROP).ifExists(c -> this.put(VuetifyNavigation.GLYPH_PROP, Glyph.builder().config((Config)c).build()));
                }
                return this;
            }
        }
    }

    public static class Builder
    extends AbstractBuilder<VuetifyNavigation> {
        public Builder title(String title) {
            this.put(VuetifyNavigation.TITLE_PROP, title);
            return this;
        }

        public Builder glyph(Glyph glyph) {
            this.put(VuetifyNavigation.GLYPH_PROP, glyph);
            return this;
        }

        public Builder items(List<Item> items) {
            this.put(VuetifyNavigation.ITEMS_PROP, items);
            return this;
        }

        public Builder config(Config node) {
            if (node.exists()) {
                node.get(VuetifyNavigation.TITLE_PROP).ifExists(c -> this.put(VuetifyNavigation.TITLE_PROP, c.asString()));
                node.get(VuetifyNavigation.GLYPH_PROP).ifExists(c -> this.put(VuetifyNavigation.GLYPH_PROP, Glyph.builder().config((Config)c).build()));
                node.get(VuetifyNavigation.ITEMS_PROP).ifExists(c -> this.put(VuetifyNavigation.ITEMS_PROP, c.asNodeList().stream().map(n -> Item.from(n)).collect(Collectors.toList())));
            }
            return this;
        }

        @Override
        public VuetifyNavigation build() {
            String title = null;
            Glyph glyph = null;
            List<Item> items = null;
            block10: for (Map.Entry<String, Object> entry : this.values()) {
                String attr = entry.getKey();
                Object val = entry.getValue();
                switch (attr) {
                    case "title": {
                        title = Builder.asType(val, String.class);
                        continue block10;
                    }
                    case "glyph": {
                        glyph = Builder.asType(val, Glyph.class);
                        continue block10;
                    }
                    case "items": {
                        items = Builder.asList(val, Item.class);
                        continue block10;
                    }
                }
                throw new IllegalStateException("Unkown attribute: " + attr);
            }
            return new VuetifyNavigation(title, glyph, items);
        }
    }
}

