/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.sitegen.asciidoctor;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import org.asciidoctor.ast.Block;
import org.asciidoctor.ast.StructuralNode;
import org.asciidoctor.extension.BlockProcessor;
import org.asciidoctor.extension.Reader;

public class CardBlockProcessor
extends BlockProcessor {
    public static final String BLOCKLINK_TEXT = "@@blocklink@@";
    private static final Map<String, Object> CONFIG = CardBlockProcessor.createConfig(":open");

    public CardBlockProcessor() {
        super("CARD", CONFIG);
        this.setConfigFinalized();
    }

    public Object process(StructuralNode parent, Reader reader, Map<String, Object> attributes) {
        HashMap<String, String> opts = new HashMap<String, String>();
        opts.put("content_model", "compound");
        Block block = this.createBlock(parent, "card", reader.readLines(), attributes, opts);
        String link = (String)attributes.get("link");
        if (link != null) {
            this.parseContent((StructuralNode)block, Arrays.asList("<<" + link + "," + BLOCKLINK_TEXT + ">>"));
            block.getContent();
        }
        return block;
    }

    private static Map<String, Object> createConfig(String ... blockTypes) {
        HashMap<String, Object> config = new HashMap<String, Object>();
        config.put("contexts", Arrays.asList(blockTypes));
        return config;
    }
}

