/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.sitegen.freemarker;

import freemarker.ext.beans.BeansWrapper;
import freemarker.template.TemplateHashModel;
import freemarker.template.TemplateModel;
import freemarker.template.TemplateModelException;
import io.helidon.sitegen.freemarker.ObjectWrapper;
import io.helidon.sitegen.freemarker.SimpleMethodModel;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Objects;
import org.asciidoctor.ast.ContentNode;

public class ContentNodeHashModel
implements TemplateHashModel {
    private final ObjectWrapper objectWrapper;
    private final ContentNode contentNode;

    public ContentNodeHashModel(ObjectWrapper objectWrapper, ContentNode node) {
        Objects.requireNonNull(objectWrapper);
        this.objectWrapper = objectWrapper;
        Objects.requireNonNull(node);
        this.contentNode = node;
    }

    public ContentNode getContentNode() {
        return this.contentNode;
    }

    public TemplateModel get(String key) throws TemplateModelException {
        if ("this".equals(key)) {
            return this;
        }
        String getterName = "get";
        getterName = getterName + Character.toUpperCase(key.charAt(0));
        getterName = getterName + key.substring(1);
        Method getterMethod = null;
        for (Method m : this.contentNode.getClass().getMethods()) {
            if (!getterName.equals(m.getName()) || m.getParameterCount() != 0) continue;
            getterMethod = m;
            break;
        }
        if (getterMethod != null) {
            try {
                return this.objectWrapper.wrap(getterMethod.invoke((Object)this.contentNode, new Object[0]));
            }
            catch (IllegalAccessException | IllegalArgumentException | SecurityException | InvocationTargetException ex) {
                throw new TemplateModelException(String.format("Error during getter invocation: node=%s, methodname=%s", this.contentNode, getterMethod.getName()), ex);
            }
        }
        if (SimpleMethodModel.hasMethodWithName(this.contentNode, key)) {
            return new SimpleMethodModel((BeansWrapper)this.objectWrapper, this.contentNode, key);
        }
        return null;
    }

    public boolean isEmpty() throws TemplateModelException {
        return false;
    }
}

