/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.sitegen.freemarker;

import freemarker.core.Environment;
import freemarker.template.TemplateDirectiveBody;
import freemarker.template.TemplateDirectiveModel;
import freemarker.template.TemplateException;
import freemarker.template.TemplateModel;
import freemarker.template.TemplateModelException;
import freemarker.template.TemplateScalarModel;
import io.helidon.sitegen.freemarker.ContentNodeHashModel;
import java.io.IOException;
import java.util.Map;
import org.asciidoctor.ast.Block;
import org.asciidoctor.ast.Cell;
import org.asciidoctor.ast.ContentNode;

public class PassthroughFixDirective
implements TemplateDirectiveModel {
    private static final String PLACEHOLDER = "\u00960\u0097";
    private static final String EMPHASIS = "_";
    private static final String STRONG = "*";
    private static final String MONOSPACE = "`";
    private static final String SUPERSCRIPT = "^";
    private static final String SUBSCRIPT = "~";
    private static final String DOUBLE_QUOTES = "\"`";
    private static final String SINGLE_QUOTES = "'`";
    private static final String SINGLE_PLUS = "+";
    private static final String TRIPLE_PLUS = "+++";
    private static final String PASS_MACRO_C_BEGIN = "pass:c[";
    private static final String PASS_MACRO_BEGIN = "pass:[";
    private static final String PASS_MACRO_END = "]";

    public void execute(Environment env, Map params, TemplateModel[] loopVars, TemplateDirectiveBody body) throws TemplateException, IOException {
        if (loopVars.length != 0) {
            throw new TemplateModelException("This directive does not allow loop variables.");
        }
        if (body != null) {
            throw new TemplateModelException("This directive does not allow body content.");
        }
        TemplateModel textVar = env.getVariable("text");
        if (!(textVar instanceof TemplateScalarModel)) {
            throw new TemplateModelException("text variable is not a TemplateScalarModel");
        }
        String text = ((TemplateScalarModel)textVar).getAsString();
        if (PLACEHOLDER.equals(text)) {
            String source;
            TemplateModel parentVar = env.getVariable("parent");
            if (!(parentVar instanceof ContentNodeHashModel)) {
                throw new TemplateModelException("pareant variable is not a ContentNodeHashModel");
            }
            ContentNode parent = ((ContentNodeHashModel)parentVar).getContentNode();
            if (parent instanceof Block) {
                source = ((Block)parent).getSource();
            } else if (parent instanceof Cell) {
                source = ((Cell)parent).getSource();
            } else {
                throw new TemplateModelException("parent is not a Block or a Cell");
            }
            if (source == null || source.isEmpty()) {
                throw new TemplateModelException("source is null or empty");
            }
            String fixed = PassthroughFixDirective.formatInlineSource(source);
            env.getOut().write(fixed);
        } else {
            env.getOut().write(text);
        }
    }

    private static String formatInlineSource(String source) throws TemplateModelException {
        if (PassthroughFixDirective.isTextDelimitedBy(source, EMPHASIS, EMPHASIS)) {
            return PassthroughFixDirective.formatInlineText(source, EMPHASIS, EMPHASIS);
        }
        if (PassthroughFixDirective.isTextDelimitedBy(source, STRONG, STRONG)) {
            return PassthroughFixDirective.formatInlineText(source, STRONG, STRONG);
        }
        if (PassthroughFixDirective.isTextDelimitedBy(source, MONOSPACE, MONOSPACE)) {
            return PassthroughFixDirective.formatInlineText(source, MONOSPACE, MONOSPACE);
        }
        if (PassthroughFixDirective.isTextDelimitedBy(source, SUBSCRIPT, SUBSCRIPT)) {
            return PassthroughFixDirective.formatInlineText(source, SUBSCRIPT, SUBSCRIPT);
        }
        if (PassthroughFixDirective.isTextDelimitedBy(source, SUPERSCRIPT, SUPERSCRIPT)) {
            return PassthroughFixDirective.formatInlineText(source, SUPERSCRIPT, SUPERSCRIPT);
        }
        if (PassthroughFixDirective.isTextDelimitedBy(source, DOUBLE_QUOTES, DOUBLE_QUOTES)) {
            return PassthroughFixDirective.formatInlineText(source, DOUBLE_QUOTES, DOUBLE_QUOTES);
        }
        if (PassthroughFixDirective.isTextDelimitedBy(source, SINGLE_QUOTES, SINGLE_QUOTES)) {
            return PassthroughFixDirective.formatInlineText(source, SINGLE_QUOTES, SINGLE_QUOTES);
        }
        return PassthroughFixDirective.formatInlineText(source, "", "");
    }

    private static String formatInlineText(String text, String beginDelimiter, String endDelimiter) {
        String enclosed = PassthroughFixDirective.getEnclosedText(text, beginDelimiter, endDelimiter);
        if (PassthroughFixDirective.isTextDelimitedBy(enclosed, TRIPLE_PLUS, TRIPLE_PLUS)) {
            return PassthroughFixDirective.getEnclosedText(enclosed, TRIPLE_PLUS, TRIPLE_PLUS);
        }
        if (PassthroughFixDirective.isTextDelimitedBy(enclosed, PASS_MACRO_BEGIN, PASS_MACRO_END)) {
            return PassthroughFixDirective.getEnclosedText(enclosed, PASS_MACRO_BEGIN, PASS_MACRO_END);
        }
        if (PassthroughFixDirective.isTextDelimitedBy(enclosed, SINGLE_PLUS, SINGLE_PLUS)) {
            String enclosedPassthrough = PassthroughFixDirective.getEnclosedText(enclosed, SINGLE_PLUS, SINGLE_PLUS);
            return PassthroughFixDirective.escapeSpecialCharacters(enclosedPassthrough);
        }
        if (PassthroughFixDirective.isTextDelimitedBy(text, PASS_MACRO_C_BEGIN, PASS_MACRO_END)) {
            String enclosedPassthrough = PassthroughFixDirective.getEnclosedText(enclosed, PASS_MACRO_C_BEGIN, PASS_MACRO_END);
            return PassthroughFixDirective.escapeSpecialCharacters(enclosedPassthrough);
        }
        return enclosed;
    }

    private static String escapeSpecialCharacters(String text) {
        return text.replaceAll("<", "&lt;").replaceAll(">", "&gt;").replaceAll("&", "&amp;");
    }

    private static String getEnclosedText(String text, String begin, String end) {
        return text.substring(begin.length(), text.length() - end.length());
    }

    private static boolean isTextDelimitedBy(String text, String begin, String end) {
        return text.startsWith(begin) && text.endsWith(end) && text.length() > begin.length() + end.length();
    }
}

