/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.sitegen.freemarker;

import freemarker.core.Environment;
import freemarker.template.TemplateDirectiveBody;
import freemarker.template.TemplateDirectiveModel;
import freemarker.template.TemplateException;
import freemarker.template.TemplateModel;
import freemarker.template.TemplateModelException;
import freemarker.template.TemplateScalarModel;
import io.helidon.sitegen.Page;
import io.helidon.sitegen.SearchEntry;
import io.helidon.sitegen.freemarker.ContentNodeHashModel;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.asciidoctor.ast.ContentNode;
import org.asciidoctor.ast.StructuralNode;

public class SearchIndexDirective
implements TemplateDirectiveModel {
    private final List<SearchEntry> entries = new ArrayList<SearchEntry>();

    public void execute(Environment env, Map params, TemplateModel[] loopVars, TemplateDirectiveBody body) throws TemplateException, IOException {
        TemplateModel dataModel = env.getDataModel().get("this");
        if (!(dataModel instanceof ContentNodeHashModel)) {
            throw new TemplateModelException("Data model is not a ContentNodeHashModel");
        }
        ContentNode node = ((ContentNodeHashModel)dataModel).getContentNode();
        if (node == null) {
            throw new TemplateModelException("'this' has a null content-node");
        }
        String title = null;
        if (params.containsKey("title")) {
            Object titleParam = params.get("title");
            if (!(titleParam instanceof TemplateScalarModel)) {
                throw new TemplateModelException("The title parameter must be a string");
            }
            title = ((TemplateScalarModel)titleParam).getAsString();
        } else if (node instanceof StructuralNode) {
            title = SearchIndexDirective.stripHtmlMarkups(((StructuralNode)node).getTitle());
        }
        if (title == null) {
            throw new TemplateModelException("missing title");
        }
        Object pageAttr = node.getDocument().getAttribute((Object)"page");
        if (!(pageAttr instanceof Page)) {
            throw new TemplateModelException("document attribute page is not valid");
        }
        Page page = (Page)pageAttr;
        if (body == null) {
            throw new TemplateModelException("Body is null");
        }
        StringWriter writer = new StringWriter();
        body.render((Writer)writer);
        SearchEntry entry = new SearchEntry(page.getTargetPath(), SearchIndexDirective.stripHtmlMarkups(writer.toString()), title);
        this.entries.add(entry);
    }

    private static String stripHtmlMarkups(String content) {
        if (content == null) {
            return null;
        }
        return content.replaceAll("\\<.*?\\>", " ").replaceAll("\\\\n", "").replaceAll("\\s+", " ");
    }

    public List<SearchEntry> getEntries() {
        return this.entries;
    }
}

