/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.sitegen.freemarker;

import freemarker.cache.URLTemplateLoader;
import io.helidon.sitegen.Helper;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;

public class TemplateLoader
extends URLTemplateLoader {
    private static final String TEMPLATES_RESOURCE = "/helidon-sitegen-templates/";
    private static final String TEMPLATE_FILE_EXT = ".ftl";
    private final Path templatesDir;

    public TemplateLoader() {
        try {
            this.templatesDir = Helper.loadResourceDirAsPath(TEMPLATES_RESOURCE);
        }
        catch (IOException | IllegalStateException | URISyntaxException ex) {
            throw new IllegalStateException("Unable to get templates directory", ex);
        }
    }

    protected URL getURL(String name) {
        Path tpl;
        String tplName = name;
        if (!tplName.endsWith(TEMPLATE_FILE_EXT)) {
            tplName = tplName + TEMPLATE_FILE_EXT;
        }
        if (!Files.exists(tpl = this.templatesDir.resolve(tplName), new LinkOption[0])) {
            return null;
        }
        try {
            return tpl.toUri().toURL();
        }
        catch (MalformedURLException ex) {
            throw new RuntimeException(ex);
        }
    }
}

