/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.sitegen.freemarker;

import freemarker.core.Environment;
import freemarker.template.TemplateDirectiveBody;
import freemarker.template.TemplateDirectiveModel;
import freemarker.template.TemplateException;
import freemarker.template.TemplateModel;
import freemarker.template.TemplateModelException;
import io.helidon.sitegen.Page;
import io.helidon.sitegen.freemarker.ContentNodeHashModel;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.HashMap;
import java.util.Map;
import org.asciidoctor.ast.ContentNode;

public class VueBindingsDirective
implements TemplateDirectiveModel {
    private final Map<String, String> bindings = new HashMap<String, String>();

    public void execute(Environment env, Map params, TemplateModel[] loopVars, TemplateDirectiveBody body) throws TemplateException, IOException {
        TemplateModel dataModel = env.getDataModel().get("this");
        if (!(dataModel instanceof ContentNodeHashModel)) {
            throw new TemplateModelException("Data model is not a ContentNodeHashModel");
        }
        ContentNode node = ((ContentNodeHashModel)dataModel).getContentNode();
        if (node == null) {
            throw new TemplateModelException("'this' has a null content-node");
        }
        Object page = node.getDocument().getAttribute((Object)"page");
        if (page == null || !(page instanceof Page)) {
            throw new TemplateModelException("Unable to get page instance");
        }
        if (body == null) {
            throw new TemplateModelException("Body is null");
        }
        StringWriter writer = new StringWriter();
        body.render((Writer)writer);
        this.bindings.put(((Page)page).getSourcePath(), writer.toString());
    }

    public Map<String, String> getBindings() {
        return this.bindings;
    }
}

