/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.sitegen.maven;

import io.helidon.sitegen.RenderingException;
import io.helidon.sitegen.Site;
import java.io.File;
import java.util.Map;
import java.util.Properties;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;

@Mojo(name="generate", defaultPhase=LifecyclePhase.COMPILE, requiresProject=true)
public class GenerateMojo
extends AbstractMojo {
    @Parameter(defaultValue="${project}", readonly=true, required=true)
    private MavenProject project;
    @Parameter(property="helidon.sitegen.siteOutputDirectory", defaultValue="${project.build.directory}/site", required=true)
    private File siteOutputDirectory;
    @Parameter(property="helidon.sitegen.siteSourceDirectory", defaultValue="${project.basedir}/src/main/site", required=true)
    private File siteSourceDirectory;
    @Parameter(property="helidon.sitegen.siteConfigFile", required=true)
    private File siteConfigFile;
    @Parameter(property="helidon.sitegen.siteGenerateSkip", defaultValue="false", required=false)
    private boolean siteGenerateSkip;
    private Site site = null;

    public void execute() throws MojoExecutionException, MojoFailureException {
        if (this.siteGenerateSkip) {
            this.getLog().info((CharSequence)"processing is skipped.");
            return;
        }
        this.project.addCompileSourceRoot(this.siteSourceDirectory.getAbsolutePath());
        Properties properties = new Properties();
        properties.putAll((Map<?, ?>)this.project.getProperties());
        properties.setProperty("project.groupId", this.project.getGroupId());
        properties.setProperty("project.artifactId", this.project.getArtifactId());
        properties.setProperty("project.version", this.project.getVersion());
        properties.setProperty("project.basedir", this.project.getBasedir().getAbsolutePath());
        this.site = Site.builder().config(this.siteConfigFile, properties).build();
        if (this.getLog().isDebugEnabled()) {
            System.setProperty("jruby.cli.verbose", "true");
        }
        try {
            this.site.generate(this.siteSourceDirectory, this.siteOutputDirectory);
        }
        catch (RenderingException ex) {
            throw new MojoExecutionException(ex.getMessage(), (Exception)ex);
        }
    }

    public Site getSite() {
        return this.site;
    }
}

