/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.sitegen.maven;

import java.io.File;
import java.io.IOException;
import org.apache.maven.archiver.MavenArchiveConfiguration;
import org.apache.maven.archiver.MavenArchiver;
import org.apache.maven.artifact.DependencyResolutionRequiredException;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.archiver.Archiver;
import org.codehaus.plexus.archiver.jar.JarArchiver;
import org.codehaus.plexus.archiver.jar.ManifestException;

@Mojo(name="package", defaultPhase=LifecyclePhase.PACKAGE, requiresProject=true)
public class PackageMojo
extends AbstractMojo {
    private static final String[] DEFAULT_EXCLUDES = new String[0];
    private static final String[] DEFAULT_INCLUDES = new String[]{"**/**"};
    @Parameter(defaultValue="${project}", readonly=true)
    private MavenProject project;
    @Parameter(defaultValue="${session}", readonly=true)
    private MavenSession session;
    @Component(role=Archiver.class, hint="jar")
    private JarArchiver jarArchiver;
    @Parameter(defaultValue="${project.build.directory}", required=true)
    private File siteArchiveOutputDirectory;
    @Parameter(defaultValue="${project.build.directory}/site", required=true)
    private File siteOutputDirectory;
    @Parameter(defaultValue="${project.build.finalName}", required=true)
    private String siteArchiveFinalName;
    @Parameter
    private String[] siteArchiveIncludes;
    @Parameter
    private String[] siteArchiveExcludes;
    @Parameter(property="helidon.sitegen.siteArchiveSkip", defaultValue="false", required=false)
    private boolean siteArchiveSkip;

    public void execute() throws MojoExecutionException, MojoFailureException {
        if (this.siteArchiveSkip) {
            this.getLog().info((CharSequence)"processing is skipped.");
            return;
        }
        this.getLog().info((CharSequence)("Assembling site JAR [" + this.project.getArtifactId() + "]"));
        File jarFile = new File(this.siteArchiveOutputDirectory, this.siteArchiveFinalName + ".jar");
        MavenArchiver mvnArchiver = new MavenArchiver();
        mvnArchiver.setArchiver(this.jarArchiver);
        mvnArchiver.setOutputFile(jarFile);
        mvnArchiver.getArchiver().addDirectory(this.siteOutputDirectory, this.getIncludes(), this.getExcludes());
        try {
            mvnArchiver.createArchive(this.session, this.project, new MavenArchiveConfiguration());
        }
        catch (IOException | DependencyResolutionRequiredException | ManifestException ex) {
            throw new MojoExecutionException("Error assembling site archive", (Exception)ex);
        }
        this.project.getArtifact().setFile(jarFile);
    }

    private String[] getIncludes() {
        if (this.siteArchiveIncludes != null && this.siteArchiveIncludes.length > 0) {
            return this.siteArchiveIncludes;
        }
        return DEFAULT_INCLUDES;
    }

    private String[] getExcludes() {
        if (this.siteArchiveExcludes != null && this.siteArchiveExcludes.length > 0) {
            return this.siteArchiveExcludes;
        }
        return DEFAULT_EXCLUDES;
    }
}

