/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.sitegen.maven;

import com.github.difflib.DiffUtils;
import com.github.difflib.algorithm.DiffException;
import io.helidon.sitegen.maven.AbstractAsciiDocMojo;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.security.DigestInputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;

@Mojo(name="preprocess-adoc", defaultPhase=LifecyclePhase.GENERATE_SOURCES, requiresProject=true)
public class PreprocessAsciiDocMojo
extends AbstractAsciiDocMojo {
    @Parameter(property="helidon.sitegen.check", defaultValue="false")
    private boolean check;

    @Override
    void postProcessFile(Path adocFilePath, Path outputPath) throws IOException, MojoFailureException, MojoExecutionException {
        if (this.check) {
            this.compareFiles(adocFilePath, outputPath);
        }
    }

    @Override
    String outputType() {
        return "preprocessed";
    }

    private void compareFiles(Path pathA, Path pathB) throws IOException, MojoFailureException, MojoExecutionException {
        if (pathA.equals(pathB)) {
            this.getLog().warn((Throwable)new IllegalArgumentException("'check' set to true but it will always pass: input and output files are the same"));
        }
        try {
            byte[] inputDigest = this.digest(pathA);
            byte[] outputDigest = this.digest(pathB);
            if (!Arrays.equals(inputDigest, outputDigest)) {
                throw new MojoFailureException(String.format("file %s does not match its expected pre-processed form; the commit might need an up-to-date file from running 'preprocess-adoc'%n%s ", pathA.toString(), this.formatDiffs(pathA, pathB)));
            }
        }
        catch (NoSuchAlgorithmException e) {
            throw new MojoExecutionException("error checking for matching input and output files", (Exception)e);
        }
        catch (DiffException ex) {
            throw new MojoExecutionException(String.format("Error comparing %s and %s", pathA.toString(), pathB.toString()), (Exception)((Object)ex));
        }
    }

    private byte[] digest(Path path) throws IOException, NoSuchAlgorithmException {
        MessageDigest md = MessageDigest.getInstance("MD5");
        byte[] buffer = new byte[256];
        try (BufferedInputStream is = new BufferedInputStream(Files.newInputStream(path, new OpenOption[0]));
             DigestInputStream dis = new DigestInputStream(is, md);){
            while (dis.read(buffer) != -1) {
            }
        }
        return md.digest();
    }

    private String formatDiffs(Path pathA, Path pathB) throws IOException, DiffException {
        List<String> contentA = Files.readAllLines(pathA);
        List<String> contentB = Files.readAllLines(pathB);
        return DiffUtils.diff(contentA, contentB).getDeltas().stream().map(Object::toString).collect(Collectors.joining(System.lineSeparator()));
    }
}

