/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.media.jsonp.common;

import io.helidon.common.http.DataChunk;
import io.helidon.common.http.Reader;
import io.helidon.common.reactive.Flow;
import io.helidon.media.common.CharBuffer;
import io.helidon.media.common.ContentReaders;
import io.helidon.media.common.ContentWriters;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.Writer;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import javax.json.Json;
import javax.json.JsonReader;
import javax.json.JsonReaderFactory;
import javax.json.JsonStructure;
import javax.json.JsonWriter;
import javax.json.JsonWriterFactory;

public final class JsonProcessing {
    private final JsonReaderFactory jsonReaderFactory;
    private final JsonWriterFactory jsonWriterFactory;

    private JsonProcessing(JsonReaderFactory readerFactory, JsonWriterFactory writerFactory) {
        this.jsonReaderFactory = readerFactory;
        this.jsonWriterFactory = writerFactory;
    }

    public Reader<JsonStructure> reader() {
        return this.reader(null);
    }

    public Reader<JsonStructure> reader(Charset charset) {
        return (publisher, clazz) -> ContentReaders.byteArrayReader().apply(publisher).thenApply(bytes -> {
            ByteArrayInputStream is = new ByteArrayInputStream((byte[])bytes);
            JsonReader reader = charset == null ? this.jsonReaderFactory.createReader((InputStream)is) : this.jsonReaderFactory.createReader((InputStream)is, charset);
            return reader.read();
        });
    }

    public Function<JsonStructure, Flow.Publisher<DataChunk>> writer(Charset charset) {
        return json -> {
            CharBuffer buffer = new CharBuffer();
            JsonWriter writer = this.jsonWriterFactory.createWriter((Writer)buffer);
            writer.write(json);
            writer.close();
            return (Flow.Publisher)ContentWriters.charBufferWriter((Charset)(charset == null ? StandardCharsets.UTF_8 : charset)).apply(buffer);
        };
    }

    public Function<JsonStructure, Flow.Publisher<DataChunk>> writer() {
        return this.writer(null);
    }

    public static JsonProcessing create() {
        return Builder.DEFAULT_INSTANCE;
    }

    public static JsonProcessing create(Map<String, ?> jsonPConfig) {
        return JsonProcessing.builder().jsonProcessingConfig(jsonPConfig).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder
    implements io.helidon.common.Builder<JsonProcessing> {
        private static final JsonProcessing DEFAULT_INSTANCE = new JsonProcessing(Builder.readerFactory(null), Builder.writerFactory(null));
        private JsonWriterFactory jsonWriterFactory;
        private JsonReaderFactory jsonReaderFactory;
        private Map<String, ?> jsonPConfig;

        public JsonProcessing build() {
            if (null == this.jsonReaderFactory && null == this.jsonWriterFactory && null == this.jsonPConfig) {
                return DEFAULT_INSTANCE;
            }
            if (null == this.jsonPConfig) {
                this.jsonPConfig = new HashMap();
            }
            if (null == this.jsonWriterFactory) {
                this.jsonWriterFactory = Builder.writerFactory(this.jsonPConfig);
            }
            if (null == this.jsonReaderFactory) {
                this.jsonReaderFactory = Builder.readerFactory(this.jsonPConfig);
            }
            return new JsonProcessing(this.jsonReaderFactory, this.jsonWriterFactory);
        }

        private static JsonReaderFactory readerFactory(Map<String, ?> jsonPConfig) {
            return Json.createReaderFactory(jsonPConfig);
        }

        private static JsonWriterFactory writerFactory(Map<String, ?> jsonPConfig) {
            return Json.createWriterFactory(jsonPConfig);
        }

        public Builder jsonProcessingConfig(Map<String, ?> config) {
            this.jsonPConfig = config;
            this.jsonWriterFactory = null;
            this.jsonReaderFactory = null;
            return this;
        }

        public Builder jsonWriterFactory(JsonWriterFactory factory) {
            this.jsonWriterFactory = factory;
            return this;
        }

        public Builder jsonReaderFactory(JsonReaderFactory factory) {
            this.jsonReaderFactory = factory;
            return this;
        }
    }
}

