/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.metrics;

import io.helidon.metrics.Clock;
import io.helidon.metrics.ExponentiallyDecayingReservoir;
import io.helidon.metrics.MetricImpl;
import java.util.Optional;
import java.util.concurrent.atomic.LongAdder;
import javax.json.JsonObjectBuilder;
import javax.json.JsonValue;
import org.eclipse.microprofile.metrics.Histogram;
import org.eclipse.microprofile.metrics.Metadata;
import org.eclipse.microprofile.metrics.Snapshot;

final class HelidonHistogram
extends MetricImpl
implements Histogram {
    private final Histogram delegate;

    private HelidonHistogram(String type, Metadata metadata, Histogram delegate) {
        super(type, metadata);
        this.delegate = delegate;
    }

    static HelidonHistogram create(String type, Metadata metadata) {
        return HelidonHistogram.create(type, metadata, Clock.system());
    }

    static HelidonHistogram create(String type, Metadata metadata, Clock clock) {
        return new HelidonHistogram(type, metadata, new HistogramImpl(clock));
    }

    static HelidonHistogram create(String type, Metadata metadata, Histogram delegate) {
        return new HelidonHistogram(type, metadata, delegate);
    }

    public void update(int value) {
        this.delegate.update(value);
    }

    public void update(long value) {
        this.delegate.update(value);
    }

    public long getCount() {
        return this.delegate.getCount();
    }

    public Snapshot getSnapshot() {
        return this.delegate.getSnapshot();
    }

    @Override
    protected void prometheusData(StringBuilder sb, String name, String tags) {
        MetricImpl.Units units = this.getUnits();
        Optional<String> unit = units.getPrometheusUnit();
        Snapshot snap = this.getSnapshot();
        String nameUnits = this.prometheusNameWithUnits(name + "_mean", unit);
        this.prometheusType(sb, nameUnits, "gauge");
        sb.append(nameUnits).append(tags).append(" ").append(units.convert(snap.getMean())).append("\n");
        nameUnits = this.prometheusNameWithUnits(name + "_max", unit);
        this.prometheusType(sb, nameUnits, "gauge");
        sb.append(nameUnits).append(tags).append(" ").append(units.convert(snap.getMax())).append("\n");
        nameUnits = this.prometheusNameWithUnits(name + "_min", unit);
        this.prometheusType(sb, nameUnits, "gauge");
        sb.append(nameUnits).append(tags).append(" ").append(units.convert(snap.getMin())).append("\n");
        nameUnits = this.prometheusNameWithUnits(name + "_stddev", unit);
        this.prometheusType(sb, nameUnits, "gauge");
        sb.append(nameUnits).append(tags).append(" ").append(units.convert(snap.getStdDev())).append("\n");
        nameUnits = this.prometheusNameWithUnits(name, unit);
        this.prometheusType(sb, nameUnits, "summary");
        this.prometheusHelp(sb, nameUnits);
        nameUnits = this.prometheusNameWithUnits(name, unit) + "_count";
        sb.append(nameUnits).append(tags).append(" ").append(this.getCount()).append('\n');
        nameUnits = this.prometheusNameWithUnits(name, unit);
        this.prometheusQuantile(sb, tags, units, nameUnits, "0.5", () -> ((Snapshot)snap).getMedian());
        this.prometheusQuantile(sb, tags, units, nameUnits, "0.75", () -> ((Snapshot)snap).get75thPercentile());
        this.prometheusQuantile(sb, tags, units, nameUnits, "0.95", () -> ((Snapshot)snap).get95thPercentile());
        this.prometheusQuantile(sb, tags, units, nameUnits, "0.98", () -> ((Snapshot)snap).get98thPercentile());
        this.prometheusQuantile(sb, tags, units, nameUnits, "0.99", () -> ((Snapshot)snap).get99thPercentile());
        this.prometheusQuantile(sb, tags, units, nameUnits, "0.999", () -> ((Snapshot)snap).get999thPercentile());
    }

    HistogramImpl getDelegate() {
        return this.delegate instanceof HistogramImpl ? (HistogramImpl)this.delegate : (this.delegate instanceof HelidonHistogram ? ((HelidonHistogram)this.delegate).getDelegate() : null);
    }

    @Override
    public void jsonData(JsonObjectBuilder builder) {
        JsonObjectBuilder myBuilder = JSON.createObjectBuilder();
        myBuilder.add("count", this.getCount());
        Snapshot snapshot = this.getSnapshot();
        myBuilder.add("min", snapshot.getMin());
        myBuilder.add("max", snapshot.getMax());
        myBuilder.add("mean", snapshot.getMean());
        myBuilder.add("stddev", snapshot.getStdDev());
        myBuilder.add("p50", snapshot.getMedian());
        myBuilder.add("p75", snapshot.get75thPercentile());
        myBuilder.add("p95", snapshot.get95thPercentile());
        myBuilder.add("p98", snapshot.get98thPercentile());
        myBuilder.add("p99", snapshot.get99thPercentile());
        myBuilder.add("p999", snapshot.get999thPercentile());
        builder.add(this.getName(), (JsonValue)myBuilder.build());
    }

    static final class HistogramImpl
    implements Histogram {
        private final LongAdder counter = new LongAdder();
        private final ExponentiallyDecayingReservoir reservoir;

        private HistogramImpl(Clock clock) {
            this.reservoir = new ExponentiallyDecayingReservoir(clock);
        }

        public void update(int value) {
            this.update((long)value);
        }

        public void update(long value) {
            this.counter.increment();
            this.reservoir.update(value);
        }

        public void update(long value, long timestamp) {
            this.counter.increment();
            this.reservoir.update(value, timestamp);
        }

        public long getCount() {
            return this.counter.sum();
        }

        public Snapshot getSnapshot() {
            return this.reservoir.getSnapshot();
        }
    }
}

