/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.metrics;

import io.helidon.metrics.HelidonMetric;
import java.math.BigDecimal;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.regex.Pattern;
import javax.json.Json;
import javax.json.JsonBuilderFactory;
import javax.json.JsonObjectBuilder;
import org.eclipse.microprofile.metrics.Metadata;

abstract class MetricImpl
extends Metadata
implements HelidonMetric {
    static final JsonBuilderFactory JSON = Json.createBuilderFactory(Collections.emptyMap());
    private static final Pattern DOUBLE_UNDERSCORE = Pattern.compile("__");
    private static final Pattern COLON_UNDERSCORE = Pattern.compile(":_");
    private static final Pattern CAMEL_CASE = Pattern.compile("(.)(\\p{Upper})");
    private static final Map<String, Units> PROMETHEUS_CONVERTERS = new HashMap<String, Units>();
    private static final long KILOBITS = 125L;
    private static final long MEGABITS = 125000L;
    private static final long GIGABITS = 125000000L;
    private static final long KIBIBITS = 128L;
    private static final long MEBIBITS = 131072L;
    private static final long GIBIBITS = 0x8000000L;
    private static final long KILOBYTES = 1000L;
    private static final long MEGABYTES = 1000000L;
    private static final long GIGABYTES = 1000000000L;
    private final String registryType;

    MetricImpl(String registryType, Metadata metadata) {
        super(metadata.getName(), metadata.getDisplayName(), metadata.getDescription(), metadata.getTypeRaw(), metadata.getUnit(), MetricImpl.tagsToSimpleString(metadata));
        this.registryType = registryType;
    }

    private static String tagsToSimpleString(Metadata metadata) {
        HashMap tags = metadata.getTags();
        if (tags.isEmpty()) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        for (Map.Entry entry : tags.entrySet()) {
            sb.append((String)entry.getKey()).append("=").append((String)entry.getValue());
            sb.append(",");
        }
        sb.delete(sb.length() - 1, sb.length());
        return sb.toString();
    }

    private static void addByteConverter(String metricUnit, long toByteRatio) {
        PROMETHEUS_CONVERTERS.put(metricUnit, new Units(metricUnit, "bytes", o -> ((Number)o).doubleValue() * (double)toByteRatio));
    }

    private static void addConverter(Units units) {
        PROMETHEUS_CONVERTERS.put(units.getMetricUnit(), units);
    }

    private static void addTimeConverter(String metricUnit, TimeUnit timeUnit) {
        PROMETHEUS_CONVERTERS.put(metricUnit, new TimeUnits(metricUnit, timeUnit));
    }

    @Override
    public void jsonMeta(JsonObjectBuilder builder) {
        JsonObjectBuilder metaBuilder = JSON.createObjectBuilder();
        this.addNonEmpty(metaBuilder, "unit", this.getUnit());
        this.addNonEmpty(metaBuilder, "unit", this.getUnit());
        this.addNonEmpty(metaBuilder, "type", this.getType());
        this.addNonEmpty(metaBuilder, "description", this.getDescription());
        this.addNonEmpty(metaBuilder, "displayName", this.getDisplayName());
        this.addNonEmpty(metaBuilder, "tags", MetricImpl.tagsToSimpleString(this));
        builder.add(this.getName(), metaBuilder);
    }

    @Override
    public String prometheusData() {
        StringBuilder sb = new StringBuilder();
        String name = this.prometheusName(this.getName());
        String tags = this.getTagsAsString();
        if (!tags.isEmpty()) {
            tags = "{" + tags + "}";
        }
        this.prometheusData(sb, name, tags);
        return sb.toString();
    }

    protected abstract void prometheusData(StringBuilder var1, String var2, String var3);

    void prometheusType(StringBuilder sb, String nameWithUnits, String type) {
        sb.append("# TYPE ").append(nameWithUnits).append(" ").append(type).append('\n');
    }

    void prometheusHelp(StringBuilder sb, String nameWithUnits) {
        sb.append("# HELP ").append(nameWithUnits).append(" ").append(this.getDescription() == null ? "" : this.getDescription()).append('\n');
    }

    protected final void prometheusQuantile(StringBuilder sb, String tags, Units units, String nameUnits, String quantile, Supplier<Double> value) {
        String quantileTag = "quantile=\"" + quantile + "\"";
        tags = tags.isEmpty() ? "{" + quantileTag + "}" : tags.substring(0, tags.length() - 1) + "," + quantileTag + "}";
        sb.append(nameUnits).append(tags).append(" ").append(units.convert(value.get())).append("\n");
    }

    final String prometheusNameWithUnits(String name, Optional<String> unit) {
        return name + unit.map(it -> "_" + it).orElse("");
    }

    final String prometheusName(String name) {
        String orig;
        name = name.replace('.', '_');
        name = name.replace(' ', '_');
        name = name.replace('-', '_');
        name = this.registryType + ":" + name;
        name = this.camelToSnake(name);
        while (!(orig = name).equals(name = DOUBLE_UNDERSCORE.matcher(name).replaceAll("_"))) {
        }
        while (!(orig = name).equals(name = COLON_UNDERSCORE.matcher(name).replaceAll(":"))) {
        }
        return name;
    }

    String camelToSnake(String name) {
        return CAMEL_CASE.matcher(name).replaceAll("$1_$2").toLowerCase();
    }

    void addNonEmpty(JsonObjectBuilder builder, String name, String value) {
        if (null != value && !value.isEmpty()) {
            builder.add(name, value);
        }
    }

    Units getUnits() {
        String unit = this.getUnit();
        if (null == unit || unit.isEmpty() || "none".equals(unit)) {
            return new Units(null);
        }
        Units units = PROMETHEUS_CONVERTERS.get(unit);
        if (null == units) {
            return new Units(unit, unit, o -> o);
        }
        return units;
    }

    static {
        MetricImpl.addTimeConverter("nanoseconds", TimeUnit.NANOSECONDS);
        MetricImpl.addTimeConverter("microseconds", TimeUnit.MICROSECONDS);
        MetricImpl.addTimeConverter("milliseconds", TimeUnit.MILLISECONDS);
        MetricImpl.addTimeConverter("seconds", TimeUnit.SECONDS);
        MetricImpl.addTimeConverter("milliseconds", TimeUnit.MILLISECONDS);
        MetricImpl.addTimeConverter("minutes", TimeUnit.MINUTES);
        MetricImpl.addTimeConverter("hours", TimeUnit.HOURS);
        MetricImpl.addTimeConverter("days", TimeUnit.DAYS);
        MetricImpl.addConverter(new Units("bits", "bytes", o -> (Double)o / 8.0));
        MetricImpl.addByteConverter("kilobits", 125L);
        MetricImpl.addByteConverter("megabits", 125000L);
        MetricImpl.addByteConverter("gigabits", 125000000L);
        MetricImpl.addByteConverter("kibibits", 128L);
        MetricImpl.addByteConverter("mebibits", 131072L);
        MetricImpl.addByteConverter("gibibits", 0x8000000L);
        MetricImpl.addByteConverter("kilobytes", 1000L);
        MetricImpl.addByteConverter("megabytes", 1000000L);
        MetricImpl.addByteConverter("gigabytes", 1000000000L);
        MetricImpl.addConverter(new Units("fahrenheits", "celsius", o -> (((Number)o).doubleValue() - 32.0) * 5.0 / 9.0));
        MetricImpl.addConverter(new LengthUnits("millimeters", 0.001));
        MetricImpl.addConverter(new LengthUnits("centimeters", 0.01));
        MetricImpl.addConverter(new LengthUnits("kilometers", 1000.0));
    }

    static class Units {
        private final String metricUnit;
        private final String prometheusUnit;
        private final Function<Object, Object> converter;

        Units(String unit) {
            this.metricUnit = unit;
            this.prometheusUnit = unit;
            this.converter = o -> o;
        }

        private Units(String metricUnit, String prometheusUnit, Function<Object, Object> converter) {
            this.metricUnit = metricUnit;
            this.prometheusUnit = prometheusUnit;
            this.converter = converter;
        }

        String getMetricUnit() {
            return this.metricUnit;
        }

        Optional<String> getPrometheusUnit() {
            return Optional.ofNullable(this.prometheusUnit);
        }

        public Object convert(Object value) {
            double num;
            Object apply = this.converter.apply(value);
            if (apply instanceof Double && Math.floor(num = ((Double)apply).doubleValue()) == num) {
                return (long)num;
            }
            return apply;
        }
    }

    static final class TimeUnits
    extends Units {
        private static final long MILLISECONDS = 1000L;
        private static final long MICROSECONDS = 1000000L;
        private static final long NANOSECONDS = 1000000000L;
        private static final String DOUBLE_NAN = String.valueOf(Double.NaN);
        private static final BiFunction<Object, Function<Object, Object>, Object> CHECK_NANS = (o, f) -> o instanceof Double && ((Double)o).isNaN() ? DOUBLE_NAN : f.apply(o);

        private TimeUnits(String metricUnit, TimeUnit timeUnit) {
            super(metricUnit, "seconds", TimeUnits.timeConverter(timeUnit));
        }

        static Function<Object, Object> timeConverter(TimeUnit from) {
            switch (from) {
                case NANOSECONDS: {
                    return o -> CHECK_NANS.apply(o, p -> String.valueOf(new BigDecimal(String.valueOf(p)).doubleValue() / 1.0E9));
                }
                case MICROSECONDS: {
                    return o -> CHECK_NANS.apply(o, p -> String.valueOf(new BigDecimal(String.valueOf(o)).doubleValue() / 1000000.0));
                }
                case MILLISECONDS: {
                    return o -> CHECK_NANS.apply(o, p -> String.valueOf(new BigDecimal(String.valueOf(o)).doubleValue() / 1000.0));
                }
                case SECONDS: {
                    return o -> CHECK_NANS.apply(o, String::valueOf);
                }
            }
            return o -> CHECK_NANS.apply(o, p -> String.valueOf(TimeUnit.SECONDS.convert(new BigDecimal(String.valueOf(o)).longValue(), from)));
        }
    }

    private static final class LengthUnits
    extends Units {
        private LengthUnits(String metricUnit, double ratio) {
            super(metricUnit, "meters", o -> ((Number)o).doubleValue() * ratio);
        }
    }
}

