/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.metrics;

import io.helidon.common.CollectionsHelper;
import io.helidon.common.OptionalHelper;
import io.helidon.common.http.Http;
import io.helidon.common.http.MediaType;
import io.helidon.config.Config;
import io.helidon.media.jsonp.server.JsonSupport;
import io.helidon.metrics.HelidonMetric;
import io.helidon.metrics.Registry;
import io.helidon.metrics.RegistryFactory;
import io.helidon.webserver.Handler;
import io.helidon.webserver.RequestHeaders;
import io.helidon.webserver.Routing;
import io.helidon.webserver.ServerRequest;
import io.helidon.webserver.ServerResponse;
import io.helidon.webserver.Service;
import java.util.Collections;
import java.util.Comparator;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Stream;
import javax.json.Json;
import javax.json.JsonBuilderFactory;
import javax.json.JsonObject;
import javax.json.JsonObjectBuilder;
import javax.json.JsonValue;
import org.eclipse.microprofile.metrics.Counter;
import org.eclipse.microprofile.metrics.Metadata;
import org.eclipse.microprofile.metrics.Meter;
import org.eclipse.microprofile.metrics.Metric;
import org.eclipse.microprofile.metrics.MetricRegistry;
import org.eclipse.microprofile.metrics.MetricType;

public final class MetricsSupport
implements Service {
    private static final JsonBuilderFactory JSON = Json.createBuilderFactory(Collections.emptyMap());
    private static final String DEFAULT_CONTEXT = "/metrics";
    private final String context;
    private final RegistryFactory rf;
    private static final Logger LOGGER = Logger.getLogger(MetricsSupport.class.getName());

    private MetricsSupport(Builder builder) {
        this.rf = (RegistryFactory)builder.registryFactory.get();
        this.context = builder.context;
    }

    public static MetricsSupport create() {
        return MetricsSupport.builder().build();
    }

    public static MetricsSupport create(Config config) {
        return MetricsSupport.builder().config(config).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    static boolean requestsJsonData(RequestHeaders headers) {
        boolean requestsJson;
        Optional mediaType = headers.bestAccepted(new MediaType[]{MediaType.TEXT_PLAIN, MediaType.APPLICATION_JSON});
        boolean bl = requestsJson = mediaType.isPresent() && ((MediaType)mediaType.get()).equals((Object)MediaType.APPLICATION_JSON);
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine("Generating metrics for media type " + mediaType + ". requestsJson=" + requestsJson);
        }
        return requestsJson;
    }

    private static void getAll(ServerRequest req, ServerResponse res, Registry registry) {
        if (registry.empty()) {
            res.status((Http.ResponseStatus)Http.Status.NO_CONTENT_204);
            res.send();
            return;
        }
        if (MetricsSupport.requestsJsonData(req.headers())) {
            res.send((Object)MetricsSupport.toJsonData(registry));
        } else {
            res.send((Object)MetricsSupport.toPrometheusData(registry));
        }
    }

    private static void optionsAll(ServerRequest req, ServerResponse res, Registry registry) {
        if (registry.empty()) {
            res.status((Http.ResponseStatus)Http.Status.NO_CONTENT_204);
            res.send();
            return;
        }
        if (req.headers().isAccepted(MediaType.APPLICATION_JSON)) {
            res.send((Object)MetricsSupport.toJsonMeta(registry));
        } else {
            res.status((Http.ResponseStatus)Http.Status.NOT_ACCEPTABLE_406);
            res.send();
        }
    }

    static String toPrometheusData(Registry ... registries) {
        StringBuilder result = new StringBuilder();
        for (Registry registry : registries) {
            result.append(MetricsSupport.toPrometheusData(registry));
        }
        return result.toString();
    }

    static String toPrometheusData(Registry registry) {
        StringBuilder result = new StringBuilder();
        registry.stream().sorted(Comparator.comparing(HelidonMetric::getName)).forEach(mpMetric -> result.append(mpMetric.prometheusData()));
        return result.toString();
    }

    public static String toPrometheusData(Metric metric) {
        return MetricsSupport.checkMetricTypeThenRun(metric, HelidonMetric::prometheusData);
    }

    private static String checkMetricTypeThenRun(Metric metric, Function<HelidonMetric, String> fn) {
        Objects.requireNonNull(metric);
        if (!(metric instanceof HelidonMetric)) {
            throw new IllegalArgumentException(String.format("Metric of type %s is expected to implement %s but does not", metric.getClass().getName(), HelidonMetric.class.getName()));
        }
        return fn.apply((HelidonMetric)metric);
    }

    static JsonObject toJsonData(Registry ... registries) {
        JsonObjectBuilder builder = JSON.createObjectBuilder();
        for (Registry registry : registries) {
            if (registry.empty()) continue;
            builder.add(registry.type(), (JsonValue)MetricsSupport.toJsonData(registry));
        }
        return builder.build();
    }

    static JsonObject toJsonData(Registry registry) {
        JsonObjectBuilder builder = JSON.createObjectBuilder();
        registry.stream().sorted(Comparator.comparing(HelidonMetric::getName)).forEach(mpMetric -> mpMetric.jsonData(builder));
        return builder.build();
    }

    static JsonObject toJsonMeta(Registry ... registries) {
        JsonObjectBuilder builder = JSON.createObjectBuilder();
        for (Registry registry : registries) {
            if (registry.empty()) continue;
            builder.add(registry.type(), (JsonValue)MetricsSupport.toJsonMeta(registry));
        }
        return builder.build();
    }

    static JsonObject toJsonMeta(Registry registry) {
        JsonObjectBuilder builder = JSON.createObjectBuilder();
        registry.stream().sorted(Comparator.comparing(HelidonMetric::getName)).forEach(mpMetric -> mpMetric.jsonMeta(builder));
        return builder.build();
    }

    public void configureVendorMetrics(String routingName, Routing.Rules rules) {
        String metricPrefix = (null == routingName ? "" : routingName + ".") + "requests.";
        Registry vendor = this.rf.getARegistry(MetricRegistry.Type.VENDOR);
        Counter totalCount = vendor.counter(new Metadata(metricPrefix + "count", "Total number of HTTP requests", "Each request (regardless of HTTP method) will increase this counter", MetricType.COUNTER, "none"));
        Meter totalMeter = vendor.meter(new Metadata(metricPrefix + "meter", "Meter for overall HTTP requests", "Each request will mark the meter to see overall throughput", MetricType.METERED, "none"));
        vendor.counter(new Metadata("grpc.requests.count", "Total number of gRPC requests", "Each gRPC request (regardless of the method) will increase this counter", MetricType.COUNTER, "none"));
        vendor.meter(new Metadata("grpc.requests.meter", "Meter for overall gRPC requests", "Each gRPC request will mark the meter to see overall throughput", MetricType.METERED, "none"));
        rules.any(new Handler[]{(req, res) -> {
            totalCount.inc();
            totalMeter.mark();
            req.next();
        }});
    }

    public void configureEndpoint(Routing.Rules rules) {
        Registry base = this.rf.getARegistry(MetricRegistry.Type.BASE);
        Registry vendor = this.rf.getARegistry(MetricRegistry.Type.VENDOR);
        Registry app = this.rf.getARegistry(MetricRegistry.Type.APPLICATION);
        rules.any(new Handler[]{(req, res) -> {
            req.context().register((Object)app);
            req.context().register((Object)this.rf);
            req.next();
        }});
        rules.anyOf((Iterable)CollectionsHelper.listOf((Object[])new Http.RequestMethod[]{Http.Method.GET, Http.Method.OPTIONS}), new Handler[]{JsonSupport.create()});
        rules.get(this.context, new Handler[]{(req, res) -> this.getMultiple(req, res, base, app, vendor)}).options(this.context, new Handler[]{(req, res) -> this.optionsMultiple(req, res, base, app, vendor)});
        Stream.of(app, base, vendor).forEach(registry -> {
            String type = registry.type();
            rules.get(this.context + "/" + type, new Handler[]{(req, res) -> MetricsSupport.getAll(req, res, registry)}).get(this.context + "/" + type + "/{metric}", new Handler[]{(req, res) -> this.getOne(req, res, (Registry)((Object)registry))}).options(this.context + "/" + type, new Handler[]{(req, res) -> MetricsSupport.optionsAll(req, res, registry)}).options(this.context + "/" + type + "/{metric}", new Handler[]{(req, res) -> this.optionsOne(req, res, (Registry)((Object)registry))});
        });
    }

    public void update(Routing.Rules rules) {
        this.configureVendorMetrics(null, rules);
        this.configureEndpoint(rules);
    }

    private void getOne(ServerRequest req, ServerResponse res, Registry registry) {
        String metricName = req.path().param("metric");
        OptionalHelper.from(registry.getMetric(metricName)).ifPresentOrElse(metric -> {
            if (MetricsSupport.requestsJsonData(req.headers())) {
                JsonObjectBuilder builder = JSON.createObjectBuilder();
                metric.jsonData(builder);
                res.send((Object)builder.build());
            } else {
                res.send((Object)metric.prometheusData());
            }
        }, () -> {
            res.status((Http.ResponseStatus)Http.Status.NOT_FOUND_404);
            res.send();
        });
    }

    private void getMultiple(ServerRequest req, ServerResponse res, Registry ... registries) {
        if (MetricsSupport.requestsJsonData(req.headers())) {
            res.send((Object)MetricsSupport.toJsonData(registries));
        } else {
            res.send((Object)MetricsSupport.toPrometheusData(registries));
        }
    }

    private void optionsMultiple(ServerRequest req, ServerResponse res, Registry ... registries) {
        if (MetricsSupport.requestsJsonData(req.headers())) {
            res.send((Object)MetricsSupport.toJsonMeta(registries));
        } else {
            res.status((Http.ResponseStatus)Http.Status.NOT_ACCEPTABLE_406);
            res.send();
        }
    }

    private void optionsOne(ServerRequest req, ServerResponse res, Registry registry) {
        String metricName = req.path().param("metric");
        OptionalHelper.from(registry.getMetric(metricName)).ifPresentOrElse(metric -> {
            if (req.headers().isAccepted(MediaType.APPLICATION_JSON)) {
                JsonObjectBuilder builder = JSON.createObjectBuilder();
                metric.jsonMeta(builder);
                res.send((Object)builder.build());
            } else {
                res.status((Http.ResponseStatus)Http.Status.NOT_ACCEPTABLE_406);
                res.send();
            }
        }, () -> {
            res.status((Http.ResponseStatus)Http.Status.NO_CONTENT_204);
            res.send();
        });
    }

    public static final class Builder
    implements io.helidon.common.Builder<MetricsSupport> {
        private Supplier<RegistryFactory> registryFactory;
        private String context = "/metrics";
        private Config config = Config.empty();

        private Builder() {
        }

        public MetricsSupport build() {
            if (null == this.registryFactory) {
                this.registryFactory = () -> RegistryFactory.getInstance(this.config);
            }
            return new MetricsSupport(this);
        }

        public Builder config(Config config) {
            this.config = config;
            config.get("web-context").asString().ifPresent(this::context);
            config.get("context").asString().ifPresent(this::context);
            return this;
        }

        public Builder registryFactory(RegistryFactory factory) {
            this.registryFactory = () -> factory;
            return this;
        }

        @Deprecated
        public Builder context(String newContext) {
            return this.webContext(newContext);
        }

        public Builder webContext(String path) {
            this.context = path.startsWith("/") ? path : "/" + path;
            return this;
        }
    }
}

