/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.netty.util.internal;

import java.lang.reflect.Method;
import java.nio.ByteBuffer;

public final class ByteBufferUtil {
    private static final boolean CLEAN_SUPPORTED;
    private static final Method directBufferCleaner;
    private static final Method directBufferCleanerClean;

    public static void destroy(ByteBuffer buffer) {
        if (CLEAN_SUPPORTED && buffer.isDirect()) {
            try {
                Object cleaner = directBufferCleaner.invoke((Object)buffer, new Object[0]);
                directBufferCleanerClean.invoke(cleaner, new Object[0]);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private ByteBufferUtil() {
    }

    static {
        boolean v;
        Method directBufferCleanerX = null;
        Method directBufferCleanerCleanX = null;
        try {
            ByteBuffer direct = ByteBuffer.allocateDirect(1);
            directBufferCleanerX = direct.getClass().getMethod("cleaner", new Class[0]);
            directBufferCleanerX.setAccessible(true);
            Object cleaner = directBufferCleanerX.invoke((Object)direct, new Object[0]);
            try {
                Runnable runnable = (Runnable)cleaner;
                directBufferCleanerCleanX = Runnable.class.getDeclaredMethod("run", new Class[0]);
            }
            catch (ClassCastException ignored) {
                directBufferCleanerCleanX = cleaner.getClass().getMethod("clean", new Class[0]);
            }
            directBufferCleanerCleanX.invoke(cleaner, new Object[0]);
            v = true;
        }
        catch (Exception e) {
            v = false;
        }
        CLEAN_SUPPORTED = v;
        directBufferCleaner = directBufferCleanerX;
        directBufferCleanerClean = directBufferCleanerCleanX;
    }
}

