/*
 * Decompiled with CFR 0.152.
 */
package io.netty.channel;

import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelPromise;
import io.netty.channel.DefaultChannelPipeline;
import io.netty.channel.VoidChannelPromise;
import java.net.SocketAddress;

public final class ChannelHandlerInvokerUtil {
    public static void invokeChannelRegisteredNow(ChannelHandlerContext ctx) {
        try {
            ctx.handler().channelRegistered(ctx);
        }
        catch (Throwable t) {
            ChannelHandlerInvokerUtil.notifyHandlerException(ctx, t);
        }
    }

    public static void invokeChannelActiveNow(ChannelHandlerContext ctx) {
        try {
            ctx.handler().channelActive(ctx);
        }
        catch (Throwable t) {
            ChannelHandlerInvokerUtil.notifyHandlerException(ctx, t);
        }
    }

    public static void invokeChannelInactiveNow(ChannelHandlerContext ctx) {
        try {
            ctx.handler().channelInactive(ctx);
        }
        catch (Throwable t) {
            ChannelHandlerInvokerUtil.notifyHandlerException(ctx, t);
        }
    }

    public static void invokeExceptionCaughtNow(ChannelHandlerContext ctx, Throwable cause) {
        block2: {
            try {
                ctx.handler().exceptionCaught(ctx, cause);
            }
            catch (Throwable t) {
                if (!DefaultChannelPipeline.logger.isWarnEnabled()) break block2;
                DefaultChannelPipeline.logger.warn("An exception was thrown by a user handler's exceptionCaught() method while handling the following exception:", cause);
            }
        }
    }

    public static void invokeUserEventTriggeredNow(ChannelHandlerContext ctx, Object event) {
        try {
            ctx.handler().userEventTriggered(ctx, event);
        }
        catch (Throwable t) {
            ChannelHandlerInvokerUtil.notifyHandlerException(ctx, t);
        }
    }

    public static void invokeChannelReadNow(ChannelHandlerContext ctx, Object msg) {
        try {
            ctx.handler().channelRead(ctx, msg);
        }
        catch (Throwable t) {
            ChannelHandlerInvokerUtil.notifyHandlerException(ctx, t);
        }
    }

    public static void invokeChannelReadCompleteNow(ChannelHandlerContext ctx) {
        try {
            ctx.handler().channelReadComplete(ctx);
        }
        catch (Throwable t) {
            ChannelHandlerInvokerUtil.notifyHandlerException(ctx, t);
        }
    }

    public static void invokeChannelWritabilityChangedNow(ChannelHandlerContext ctx) {
        try {
            ctx.handler().channelWritabilityChanged(ctx);
        }
        catch (Throwable t) {
            ChannelHandlerInvokerUtil.notifyHandlerException(ctx, t);
        }
    }

    public static void invokeBindNow(ChannelHandlerContext ctx, SocketAddress localAddress, ChannelPromise promise) {
        try {
            ctx.handler().bind(ctx, localAddress, promise);
        }
        catch (Throwable t) {
            ChannelHandlerInvokerUtil.notifyOutboundHandlerException(t, promise);
        }
    }

    public static void invokeConnectNow(ChannelHandlerContext ctx, SocketAddress remoteAddress, SocketAddress localAddress, ChannelPromise promise) {
        try {
            ctx.handler().connect(ctx, remoteAddress, localAddress, promise);
        }
        catch (Throwable t) {
            ChannelHandlerInvokerUtil.notifyOutboundHandlerException(t, promise);
        }
    }

    public static void invokeDisconnectNow(ChannelHandlerContext ctx, ChannelPromise promise) {
        try {
            ctx.handler().disconnect(ctx, promise);
        }
        catch (Throwable t) {
            ChannelHandlerInvokerUtil.notifyOutboundHandlerException(t, promise);
        }
    }

    public static void invokeCloseNow(ChannelHandlerContext ctx, ChannelPromise promise) {
        try {
            ctx.handler().close(ctx, promise);
        }
        catch (Throwable t) {
            ChannelHandlerInvokerUtil.notifyOutboundHandlerException(t, promise);
        }
    }

    public static void invokeReadNow(ChannelHandlerContext ctx) {
        try {
            ctx.handler().read(ctx);
        }
        catch (Throwable t) {
            ChannelHandlerInvokerUtil.notifyHandlerException(ctx, t);
        }
    }

    public static void invokeWriteNow(ChannelHandlerContext ctx, Object msg, ChannelPromise promise) {
        try {
            ctx.handler().write(ctx, msg, promise);
        }
        catch (Throwable t) {
            ChannelHandlerInvokerUtil.notifyOutboundHandlerException(t, promise);
        }
    }

    public static void invokeFlushNow(ChannelHandlerContext ctx) {
        try {
            ctx.handler().flush(ctx);
        }
        catch (Throwable t) {
            ChannelHandlerInvokerUtil.notifyHandlerException(ctx, t);
        }
    }

    public static void invokeWriteAndFlushNow(ChannelHandlerContext ctx, Object msg, ChannelPromise promise) {
        ChannelHandlerInvokerUtil.invokeWriteNow(ctx, msg, promise);
        ChannelHandlerInvokerUtil.invokeFlushNow(ctx);
    }

    private static void notifyHandlerException(ChannelHandlerContext ctx, Throwable cause) {
        if (ChannelHandlerInvokerUtil.inExceptionCaught(cause)) {
            if (DefaultChannelPipeline.logger.isWarnEnabled()) {
                DefaultChannelPipeline.logger.warn("An exception was thrown by a user handler while handling an exceptionCaught event", cause);
            }
            return;
        }
        ChannelHandlerInvokerUtil.invokeExceptionCaughtNow(ctx, cause);
    }

    private static void notifyOutboundHandlerException(Throwable cause, ChannelPromise promise) {
        if (promise instanceof VoidChannelPromise) {
            return;
        }
        if (!promise.tryFailure(cause) && DefaultChannelPipeline.logger.isWarnEnabled()) {
            DefaultChannelPipeline.logger.warn("Failed to fail the promise because it's done already: {}", (Object)promise, (Object)cause);
        }
    }

    private static boolean inExceptionCaught(Throwable cause) {
        do {
            StackTraceElement[] trace;
            if ((trace = cause.getStackTrace()) == null) continue;
            for (StackTraceElement t : trace) {
                if (t == null) break;
                if (!"exceptionCaught".equals(t.getMethodName())) continue;
                return true;
            }
        } while ((cause = cause.getCause()) != null);
        return false;
    }

    private ChannelHandlerInvokerUtil() {
    }
}

