/*
 * Decompiled with CFR 0.152.
 */
package io.netty.channel;

import io.netty.channel.AbstractChannel;
import io.netty.channel.AbstractEventLoop;
import io.netty.channel.Channel;
import io.netty.channel.ChannelConfig;
import io.netty.channel.ChannelHandlerInvoker;
import io.netty.channel.ChannelMetadata;
import io.netty.channel.ChannelOutboundBuffer;
import io.netty.channel.ChannelPromise;
import io.netty.channel.DefaultChannelHandlerInvoker;
import io.netty.channel.EventLoop;
import io.netty.util.concurrent.Future;
import io.netty.util.concurrent.GlobalEventExecutor;
import io.netty.util.internal.StringUtil;
import java.net.SocketAddress;
import java.util.concurrent.TimeUnit;

public final class VoidChannel
extends AbstractChannel {
    public static final VoidChannel INSTANCE = new VoidChannel();

    private VoidChannel() {
        super(null, new AbstractEventLoop(null){
            private final ChannelHandlerInvoker invoker = new DefaultChannelHandlerInvoker(GlobalEventExecutor.INSTANCE);

            @Override
            @Deprecated
            public void shutdown() {
                GlobalEventExecutor.INSTANCE.shutdown();
            }

            @Override
            public ChannelHandlerInvoker asInvoker() {
                return this.invoker;
            }

            @Override
            public boolean inEventLoop(Thread thread) {
                return GlobalEventExecutor.INSTANCE.inEventLoop(thread);
            }

            @Override
            public boolean isShuttingDown() {
                return GlobalEventExecutor.INSTANCE.isShuttingDown();
            }

            @Override
            public Future<?> shutdownGracefully(long quietPeriod, long timeout, TimeUnit unit) {
                return GlobalEventExecutor.INSTANCE.shutdownGracefully(quietPeriod, timeout, unit);
            }

            @Override
            public Future<?> terminationFuture() {
                return GlobalEventExecutor.INSTANCE.terminationFuture();
            }

            @Override
            public boolean isShutdown() {
                return GlobalEventExecutor.INSTANCE.isShutdown();
            }

            @Override
            public boolean isTerminated() {
                return GlobalEventExecutor.INSTANCE.isTerminated();
            }

            @Override
            public boolean awaitTermination(long timeout, TimeUnit unit) throws InterruptedException {
                return GlobalEventExecutor.INSTANCE.awaitTermination(timeout, unit);
            }

            @Override
            public void execute(Runnable command) {
                GlobalEventExecutor.INSTANCE.execute(command);
            }
        });
    }

    @Override
    protected AbstractChannel.AbstractUnsafe newUnsafe() {
        return new AbstractChannel.AbstractUnsafe(){

            @Override
            public void connect(SocketAddress remoteAddress, SocketAddress localAddress, ChannelPromise promise) {
                VoidChannel.reject();
            }
        };
    }

    @Override
    protected boolean isCompatible(EventLoop loop) {
        return true;
    }

    @Override
    protected SocketAddress localAddress0() {
        return (SocketAddress)VoidChannel.reject();
    }

    @Override
    protected SocketAddress remoteAddress0() {
        return (SocketAddress)VoidChannel.reject();
    }

    @Override
    protected void doBind(SocketAddress localAddress) throws Exception {
        VoidChannel.reject();
    }

    @Override
    protected void doDisconnect() throws Exception {
        VoidChannel.reject();
    }

    @Override
    protected void doClose() throws Exception {
        VoidChannel.reject();
    }

    @Override
    protected void doBeginRead() throws Exception {
        VoidChannel.reject();
    }

    @Override
    protected void doWrite(ChannelOutboundBuffer in) throws Exception {
        VoidChannel.reject();
    }

    @Override
    public ChannelConfig config() {
        return (ChannelConfig)VoidChannel.reject();
    }

    @Override
    public boolean isOpen() {
        return (Boolean)VoidChannel.reject();
    }

    @Override
    public boolean isActive() {
        return (Boolean)VoidChannel.reject();
    }

    @Override
    public ChannelMetadata metadata() {
        return (ChannelMetadata)VoidChannel.reject();
    }

    @Override
    public String toString() {
        return StringUtil.simpleClassName(this);
    }

    private static <T> T reject() {
        throw new UnsupportedOperationException(StringUtil.simpleClassName(VoidChannel.class) + " is only for the representation of a non-existing " + StringUtil.simpleClassName(Channel.class) + '.');
    }
}

