/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.codec.memcache.binary;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufUtil;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.memcache.AbstractMemcacheObjectDecoder;
import io.netty.handler.codec.memcache.DefaultLastMemcacheContent;
import io.netty.handler.codec.memcache.DefaultMemcacheContent;
import io.netty.handler.codec.memcache.LastMemcacheContent;
import io.netty.handler.codec.memcache.binary.BinaryMemcacheMessage;
import io.netty.handler.codec.memcache.binary.BinaryMemcacheMessageHeader;
import io.netty.util.CharsetUtil;
import java.util.List;

public abstract class AbstractBinaryMemcacheDecoder<M extends BinaryMemcacheMessage<H>, H extends BinaryMemcacheMessageHeader>
extends AbstractMemcacheObjectDecoder {
    public static final int DEFAULT_MAX_CHUNK_SIZE = 8192;
    private final int chunkSize;
    private H currentHeader;
    private ByteBuf currentExtras;
    private String currentKey;
    private int alreadyReadChunkSize;
    private State state = State.READ_HEADER;

    protected AbstractBinaryMemcacheDecoder() {
        this(8192);
    }

    protected AbstractBinaryMemcacheDecoder(int chunkSize) {
        if (chunkSize < 0) {
            throw new IllegalArgumentException("chunkSize must be a positive integer: " + chunkSize);
        }
        this.chunkSize = chunkSize;
    }

    @Override
    protected void decode(ChannelHandlerContext ctx, ByteBuf in, List<Object> out) throws Exception {
        switch (this.state) {
            case READ_HEADER: {
                if (in.readableBytes() < 24) {
                    return;
                }
                this.resetDecoder();
                this.currentHeader = this.decodeHeader(in);
                this.state = State.READ_EXTRAS;
            }
            case READ_EXTRAS: {
                byte extrasLength = this.currentHeader.getExtrasLength();
                if (extrasLength > 0) {
                    if (in.readableBytes() < extrasLength) {
                        return;
                    }
                    this.currentExtras = ByteBufUtil.readBytes(ctx.alloc(), in, extrasLength);
                }
                this.state = State.READ_KEY;
            }
            case READ_KEY: {
                short keyLength = this.currentHeader.getKeyLength();
                if (keyLength > 0) {
                    if (in.readableBytes() < keyLength) {
                        return;
                    }
                    this.currentKey = in.toString(in.readerIndex(), keyLength, CharsetUtil.UTF_8);
                    in.skipBytes(keyLength);
                }
                out.add(this.buildMessage(this.currentHeader, this.currentExtras, this.currentKey));
                this.currentExtras = null;
                this.state = State.READ_VALUE;
            }
            case READ_VALUE: {
                int valueLength = this.currentHeader.getTotalBodyLength() - this.currentHeader.getKeyLength() - this.currentHeader.getExtrasLength();
                int toRead = in.readableBytes();
                if (valueLength > 0) {
                    int remainingLength;
                    if (toRead == 0) {
                        return;
                    }
                    if (toRead > this.chunkSize) {
                        toRead = this.chunkSize;
                    }
                    if (toRead > (remainingLength = valueLength - this.alreadyReadChunkSize)) {
                        toRead = remainingLength;
                    }
                    ByteBuf chunkBuffer = ByteBufUtil.readBytes(ctx.alloc(), in, toRead);
                    DefaultMemcacheContent chunk = (this.alreadyReadChunkSize += toRead) >= valueLength ? new DefaultLastMemcacheContent(chunkBuffer) : new DefaultMemcacheContent(chunkBuffer);
                    out.add(chunk);
                    if (this.alreadyReadChunkSize < valueLength) {
                        return;
                    }
                } else {
                    out.add(LastMemcacheContent.EMPTY_LAST_CONTENT);
                }
                this.state = State.READ_HEADER;
                return;
            }
        }
        throw new Error("Unknown state reached: " + (Object)((Object)this.state));
    }

    @Override
    public void channelInactive(ChannelHandlerContext ctx) throws Exception {
        super.channelInactive(ctx);
        if (this.currentExtras != null) {
            this.currentExtras.release();
        }
        this.resetDecoder();
    }

    protected void resetDecoder() {
        this.currentHeader = null;
        this.currentExtras = null;
        this.currentKey = null;
        this.alreadyReadChunkSize = 0;
    }

    protected abstract H decodeHeader(ByteBuf var1);

    protected abstract M buildMessage(H var1, ByteBuf var2, String var3);

    static enum State {
        READ_HEADER,
        READ_EXTRAS,
        READ_KEY,
        READ_VALUE;

    }
}

