/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.codec.memcache.binary;

import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.memcache.AbstractMemcacheObjectEncoder;
import io.netty.handler.codec.memcache.binary.BinaryMemcacheMessage;
import io.netty.handler.codec.memcache.binary.BinaryMemcacheMessageHeader;
import io.netty.util.CharsetUtil;

public abstract class AbstractBinaryMemcacheEncoder<M extends BinaryMemcacheMessage<H>, H extends BinaryMemcacheMessageHeader>
extends AbstractMemcacheObjectEncoder<M> {
    private static final int DEFAULT_BUFFER_SIZE = 24;

    @Override
    protected ByteBuf encodeMessage(ChannelHandlerContext ctx, M msg) {
        ByteBuf buf = ctx.alloc().buffer(24);
        this.encodeHeader(buf, msg.getHeader());
        AbstractBinaryMemcacheEncoder.encodeExtras(buf, msg.getExtras());
        AbstractBinaryMemcacheEncoder.encodeKey(buf, msg.getKey());
        return buf;
    }

    private static void encodeExtras(ByteBuf buf, ByteBuf extras) {
        if (extras == null || !extras.isReadable()) {
            return;
        }
        buf.writeBytes(extras);
    }

    private static void encodeKey(ByteBuf buf, String key) {
        if (key == null || key.isEmpty()) {
            return;
        }
        buf.writeBytes(key.getBytes(CharsetUtil.UTF_8));
    }

    protected abstract void encodeHeader(ByteBuf var1, H var2);
}

