/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.codec.memcache.binary;

import io.netty.buffer.ByteBuf;
import io.netty.handler.codec.memcache.AbstractMemcacheObject;
import io.netty.handler.codec.memcache.binary.BinaryMemcacheMessage;
import io.netty.handler.codec.memcache.binary.BinaryMemcacheMessageHeader;

public abstract class AbstractBinaryMemcacheMessage<H extends BinaryMemcacheMessageHeader>
extends AbstractMemcacheObject
implements BinaryMemcacheMessage<H> {
    private final H header;
    private final String key;
    private final ByteBuf extras;

    protected AbstractBinaryMemcacheMessage(H header, String key, ByteBuf extras) {
        this.header = header;
        this.key = key;
        this.extras = extras;
    }

    @Override
    public H getHeader() {
        return this.header;
    }

    @Override
    public String getKey() {
        return this.key;
    }

    @Override
    public ByteBuf getExtras() {
        return this.extras;
    }

    @Override
    public int refCnt() {
        if (this.extras != null) {
            return this.extras.refCnt();
        }
        return 1;
    }

    @Override
    public BinaryMemcacheMessage<H> retain() {
        if (this.extras != null) {
            this.extras.retain();
        }
        return this;
    }

    @Override
    public BinaryMemcacheMessage<H> retain(int increment) {
        if (this.extras != null) {
            this.extras.retain(increment);
        }
        return this;
    }

    @Override
    public boolean release() {
        if (this.extras != null) {
            return this.extras.release();
        }
        return false;
    }

    @Override
    public boolean release(int decrement) {
        if (this.extras != null) {
            return this.extras.release(decrement);
        }
        return false;
    }
}

