/*
 * Decompiled with CFR 0.152.
 */
package io.opencensus.trace.export;

import com.google.common.base.Preconditions;
import io.opencensus.trace.Status;
import io.opencensus.trace.export.AutoValue_SampledSpanStore_ErrorFilter;
import io.opencensus.trace.export.AutoValue_SampledSpanStore_LatencyFilter;
import io.opencensus.trace.export.AutoValue_SampledSpanStore_PerSpanNameSummary;
import io.opencensus.trace.export.AutoValue_SampledSpanStore_Summary;
import io.opencensus.trace.export.SpanData;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.ThreadSafe;

@ThreadSafe
public abstract class SampledSpanStore {
    protected SampledSpanStore() {
    }

    public abstract Summary getSummary();

    public abstract Collection<SpanData> getLatencySampledSpans(LatencyFilter var1);

    public abstract Collection<SpanData> getErrorSampledSpans(ErrorFilter var1);

    public abstract void registerSpanNamesForCollection(Collection<String> var1);

    public abstract void unregisterSpanNamesForCollection(Collection<String> var1);

    @Immutable
    public static abstract class ErrorFilter {
        ErrorFilter() {
        }

        public static ErrorFilter create(String spanName, @Nullable Status.CanonicalCode canonicalCode, int maxSpansToReturn) {
            if (canonicalCode != null) {
                Preconditions.checkArgument((canonicalCode != Status.CanonicalCode.OK ? 1 : 0) != 0, (Object)"Invalid canonical code.");
            }
            Preconditions.checkArgument((maxSpansToReturn >= 0 ? 1 : 0) != 0, (Object)"Negative maxSpansToReturn.");
            return new AutoValue_SampledSpanStore_ErrorFilter(spanName, canonicalCode, maxSpansToReturn);
        }

        public abstract String getSpanName();

        @Nullable
        public abstract Status.CanonicalCode getCanonicalCode();

        public abstract int getMaxSpansToReturn();
    }

    @Immutable
    public static abstract class LatencyFilter {
        LatencyFilter() {
        }

        public static LatencyFilter create(String spanName, long latencyLowerNs, long latencyUpperNs, int maxSpansToReturn) {
            Preconditions.checkArgument((maxSpansToReturn >= 0 ? 1 : 0) != 0, (Object)"Negative maxSpansToReturn.");
            Preconditions.checkArgument((latencyLowerNs >= 0L ? 1 : 0) != 0, (Object)"Negative latencyLowerNs");
            Preconditions.checkArgument((latencyUpperNs >= 0L ? 1 : 0) != 0, (Object)"Negative latencyUpperNs");
            return new AutoValue_SampledSpanStore_LatencyFilter(spanName, latencyLowerNs, latencyUpperNs, maxSpansToReturn);
        }

        public abstract String getSpanName();

        public abstract long getLatencyLowerNs();

        public abstract long getLatencyUpperNs();

        public abstract int getMaxSpansToReturn();
    }

    public static enum LatencyBucketBoundaries {
        ZERO_MICROSx10(0L, TimeUnit.MICROSECONDS.toNanos(10L)),
        MICROSx10_MICROSx100(TimeUnit.MICROSECONDS.toNanos(10L), TimeUnit.MICROSECONDS.toNanos(100L)),
        MICROSx100_MILLIx1(TimeUnit.MICROSECONDS.toNanos(100L), TimeUnit.MILLISECONDS.toNanos(1L)),
        MILLIx1_MILLIx10(TimeUnit.MILLISECONDS.toNanos(1L), TimeUnit.MILLISECONDS.toNanos(10L)),
        MILLIx10_MILLIx100(TimeUnit.MILLISECONDS.toNanos(10L), TimeUnit.MILLISECONDS.toNanos(100L)),
        MILLIx100_SECONDx1(TimeUnit.MILLISECONDS.toNanos(100L), TimeUnit.SECONDS.toNanos(1L)),
        SECONDx1_SECONDx10(TimeUnit.SECONDS.toNanos(1L), TimeUnit.SECONDS.toNanos(10L)),
        SECONDx10_SECONDx100(TimeUnit.SECONDS.toNanos(10L), TimeUnit.SECONDS.toNanos(100L)),
        SECONDx100_MAX(TimeUnit.SECONDS.toNanos(100L), Long.MAX_VALUE);

        private final long latencyLowerNs;
        private final long latencyUpperNs;

        private LatencyBucketBoundaries(long latencyLowerNs, long latencyUpperNs) {
            this.latencyLowerNs = latencyLowerNs;
            this.latencyUpperNs = latencyUpperNs;
        }

        public long getLatencyLowerNs() {
            return this.latencyLowerNs;
        }

        public long getLatencyUpperNs() {
            return this.latencyUpperNs;
        }
    }

    @Immutable
    public static abstract class PerSpanNameSummary {
        PerSpanNameSummary() {
        }

        public static PerSpanNameSummary create(Map<LatencyBucketBoundaries, Integer> numbersOfLatencySampledSpans, Map<Status.CanonicalCode, Integer> numbersOfErrorSampledSpans) {
            return new AutoValue_SampledSpanStore_PerSpanNameSummary(Collections.unmodifiableMap(new HashMap((Map)Preconditions.checkNotNull(numbersOfLatencySampledSpans, (Object)"numbersOfLatencySampledSpans"))), Collections.unmodifiableMap(new HashMap((Map)Preconditions.checkNotNull(numbersOfErrorSampledSpans, (Object)"numbersOfErrorSampledSpans"))));
        }

        public abstract Map<LatencyBucketBoundaries, Integer> getNumbersOfLatencySampledSpans();

        public abstract Map<Status.CanonicalCode, Integer> getNumbersOfErrorSampledSpans();
    }

    @Immutable
    public static abstract class Summary {
        Summary() {
        }

        public static Summary create(Map<String, PerSpanNameSummary> perSpanNameSummary) {
            return new AutoValue_SampledSpanStore_Summary(Collections.unmodifiableMap(new HashMap((Map)Preconditions.checkNotNull(perSpanNameSummary, (Object)"perSpanNameSummary"))));
        }

        public abstract Map<String, PerSpanNameSummary> getPerSpanNameSummary();
    }
}

