/*
 * Decompiled with CFR 0.152.
 */
package reactor.ipc.netty.channel;

import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.handler.ssl.SslHandshakeCompletionEvent;
import reactor.ipc.netty.channel.ContextHandler;

final class SslReadHandler
extends ChannelInboundHandlerAdapter {
    final ContextHandler<?> sink;
    boolean handshakeDone;

    SslReadHandler(ContextHandler<?> sink) {
        this.sink = sink;
    }

    public void channelActive(ChannelHandlerContext ctx) throws Exception {
        ctx.read();
    }

    public void channelReadComplete(ChannelHandlerContext ctx) throws Exception {
        if (!this.handshakeDone) {
            ctx.read();
        }
        super.channelReadComplete(ctx);
    }

    public void userEventTriggered(ChannelHandlerContext ctx, Object evt) throws Exception {
        if (evt instanceof SslHandshakeCompletionEvent) {
            SslHandshakeCompletionEvent handshake;
            this.handshakeDone = true;
            if (ctx.pipeline().context((ChannelHandler)this) != null) {
                ctx.pipeline().remove((ChannelHandler)this);
            }
            if ((handshake = (SslHandshakeCompletionEvent)evt).isSuccess()) {
                ctx.fireChannelActive();
            } else {
                this.sink.fireContextError(handshake.cause());
            }
        }
        super.userEventTriggered(ctx, evt);
    }
}

