/*
 * Decompiled with CFR 0.152.
 */
package reactor.ipc.netty.http.websocket;

import io.netty.buffer.ByteBuf;
import io.netty.handler.codec.http.websocketx.BinaryWebSocketFrame;
import io.netty.handler.codec.http.websocketx.TextWebSocketFrame;
import io.netty.handler.codec.http.websocketx.WebSocketFrame;
import java.nio.charset.Charset;
import java.util.function.Function;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Flux;
import reactor.ipc.netty.NettyOutbound;

public interface WebsocketOutbound
extends NettyOutbound {
    public static final Function<? super String, ? extends WebSocketFrame> stringToWebsocketFrame = TextWebSocketFrame::new;
    public static final Function<? super ByteBuf, ? extends WebSocketFrame> bytebufToWebsocketFrame = BinaryWebSocketFrame::new;

    public String selectedSubprotocol();

    @Override
    default public NettyOutbound send(Publisher<? extends ByteBuf> dataStream) {
        return this.sendObject((Publisher<?>)Flux.from(dataStream).map(bytebufToWebsocketFrame));
    }

    @Override
    default public NettyOutbound sendString(Publisher<? extends String> dataStream, Charset charset) {
        return this.sendObject((Publisher<?>)Flux.from(dataStream).map(stringToWebsocketFrame));
    }
}

