/*
 * Decompiled with CFR 0.152.
 */
package io.r2dbc.postgresql.client;

import java.time.Duration;
import reactor.netty.resources.LoopResources;
import reactor.util.annotation.Nullable;

public final class ConnectionSettings {
    @Nullable
    private final Duration connectTimeout;
    private final boolean tcpKeepAlive;
    private final boolean tcpNoDelay;
    @Nullable
    private final LoopResources loopResources;

    public ConnectionSettings(@Nullable Duration connectTimeout, boolean tcpKeepAlive, boolean tcpNoDelay, @Nullable LoopResources loopResources) {
        this.tcpKeepAlive = tcpKeepAlive;
        this.tcpNoDelay = tcpNoDelay;
        this.connectTimeout = connectTimeout;
        this.loopResources = loopResources;
    }

    @Nullable
    Duration getConnectTimeout() {
        return this.connectTimeout;
    }

    boolean isTcpKeepAlive() {
        return this.tcpKeepAlive;
    }

    boolean isTcpNoDelay() {
        return this.tcpNoDelay;
    }

    boolean hasLoopResources() {
        return this.loopResources != null;
    }

    LoopResources getRequiredLoopResources() {
        if (!this.hasLoopResources()) {
            throw new IllegalStateException("No LoopResources configured");
        }
        return this.loopResources;
    }
}

