/*
 * Decompiled with CFR 0.152.
 */
package io.rsocket.transport.netty;

import io.netty.buffer.ByteBuf;
import io.netty.channel.Channel;
import io.netty.channel.ChannelPromise;
import io.netty.channel.EventLoop;
import io.netty.util.ReferenceCountUtil;
import io.netty.util.ReferenceCounted;
import io.netty.util.concurrent.Future;
import java.nio.channels.ClosedChannelException;
import java.util.Queue;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;
import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;
import java.util.function.Function;
import org.reactivestreams.Publisher;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import reactor.core.CoreSubscriber;
import reactor.core.Fuseable;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Operators;
import reactor.netty.FutureMono;
import reactor.util.concurrent.Queues;

class SendPublisher<V extends ReferenceCounted>
extends Flux<ByteBuf> {
    private static final AtomicIntegerFieldUpdater<SendPublisher> WIP = AtomicIntegerFieldUpdater.newUpdater(SendPublisher.class, "wip");
    private static final int MAX_SIZE = Queues.SMALL_BUFFER_SIZE;
    private static final int REFILL_SIZE = MAX_SIZE / 2;
    private static final AtomicReferenceFieldUpdater<SendPublisher, Object> INNER_SUBSCRIBER = AtomicReferenceFieldUpdater.newUpdater(SendPublisher.class, Object.class, "innerSubscriber");
    private static final AtomicIntegerFieldUpdater<SendPublisher> TERMINATED = AtomicIntegerFieldUpdater.newUpdater(SendPublisher.class, "terminated");
    private final Publisher<ByteBuf> source;
    private final Channel channel;
    private final EventLoop eventLoop;
    private final Queue<ByteBuf> queue;
    private final AtomicBoolean completed = new AtomicBoolean();
    private final Function<ByteBuf, V> transformer;
    private final SizeOf<V> sizeOf;
    private volatile int terminated;
    private int pending;
    private volatile int wip;
    private volatile Object innerSubscriber;
    private long requested;
    private long requestedUpstream = MAX_SIZE;
    private boolean fuse;

    SendPublisher(Publisher<ByteBuf> source, Channel channel, Function<ByteBuf, V> transformer, SizeOf<V> sizeOf) {
        this((Queue)Queues.small().get(), source, channel, transformer, sizeOf);
    }

    SendPublisher(Queue<ByteBuf> queue, Publisher<ByteBuf> source, Channel channel, Function<ByteBuf, V> transformer, SizeOf<V> sizeOf) {
        this.source = source;
        this.channel = channel;
        this.queue = queue;
        this.eventLoop = channel.eventLoop();
        this.transformer = transformer;
        this.sizeOf = sizeOf;
        this.fuse = queue instanceof Fuseable.QueueSubscription;
    }

    private ChannelPromise writeCleanupPromise(V poll) {
        return this.channel.newPromise().addListener(future -> {
            if (this.requested != Long.MAX_VALUE) {
                --this.requested;
            }
            --this.requestedUpstream;
            --this.pending;
            InnerSubscriber is = (InnerSubscriber)INNER_SUBSCRIBER.get(this);
            if (is != null) {
                is.tryRequestMoreUpstream();
                this.tryComplete(is);
            }
            if (poll.refCnt() > 0) {
                ReferenceCountUtil.safeRelease((Object)poll);
            }
        });
    }

    private void tryComplete(InnerSubscriber is) {
        if (this.pending == 0 && this.completed.get() && this.queue.isEmpty() && this.terminated == 0 && !is.pendingFlush.get()) {
            TERMINATED.set(this, 1);
            is.destination.onComplete();
        }
    }

    public void subscribe(CoreSubscriber<? super ByteBuf> destination) {
        InnerSubscriber innerSubscriber = new InnerSubscriber(destination);
        if (!INNER_SUBSCRIBER.compareAndSet(this, null, innerSubscriber)) {
            Operators.error(destination, (Throwable)new IllegalStateException("SendPublisher only allows one subscription"));
        } else {
            InnerSubscription innerSubscription = new InnerSubscription(innerSubscriber);
            destination.onSubscribe((Subscription)innerSubscription);
            this.source.subscribe((Subscriber)innerSubscriber);
        }
    }

    private class InnerSubscription
    implements Subscription {
        private final InnerSubscriber innerSubscriber;

        private InnerSubscription(InnerSubscriber innerSubscriber) {
            this.innerSubscriber = innerSubscriber;
        }

        public void request(long n) {
            if (SendPublisher.this.eventLoop.inEventLoop()) {
                SendPublisher.this.requested = Operators.addCap((long)n, (long)SendPublisher.this.requested);
                this.innerSubscriber.tryDrain();
            } else {
                SendPublisher.this.eventLoop.execute(() -> this.request(n));
            }
        }

        public void cancel() {
            TERMINATED.set(SendPublisher.this, 1);
            while (!SendPublisher.this.queue.isEmpty()) {
                ByteBuf poll = (ByteBuf)SendPublisher.this.queue.poll();
                if (poll == null) continue;
                ReferenceCountUtil.safeRelease((Object)poll);
            }
        }
    }

    private class InnerSubscriber
    implements Subscriber<ByteBuf> {
        final CoreSubscriber<? super ByteBuf> destination;
        volatile Subscription s;
        private AtomicBoolean pendingFlush = new AtomicBoolean();

        private InnerSubscriber(CoreSubscriber<? super ByteBuf> destination) {
            this.destination = destination;
            FutureMono.from((Future)SendPublisher.this.channel.closeFuture()).doFinally(s -> this.onError(new ClosedChannelException())).subscribe();
        }

        public void onSubscribe(Subscription s) {
            this.s = s;
            s.request((long)MAX_SIZE);
            this.tryDrain();
        }

        public void onNext(ByteBuf t) {
            if (SendPublisher.this.terminated == 0) {
                if (!SendPublisher.this.fuse && !SendPublisher.this.queue.offer(t)) {
                    throw new IllegalStateException("missing back pressure");
                }
                this.tryDrain();
            }
        }

        public void onError(Throwable t) {
            if (TERMINATED.compareAndSet(SendPublisher.this, 0, 1)) {
                try {
                    this.s.cancel();
                    this.destination.onError(t);
                }
                finally {
                    ByteBuf byteBuf = (ByteBuf)SendPublisher.this.queue.poll();
                    while (byteBuf != null) {
                        ReferenceCountUtil.safeRelease((Object)byteBuf);
                        byteBuf = (ByteBuf)SendPublisher.this.queue.poll();
                    }
                }
            }
        }

        public void onComplete() {
            if (SendPublisher.this.completed.compareAndSet(false, true)) {
                this.tryDrain();
            }
        }

        private void tryRequestMoreUpstream() {
            if (SendPublisher.this.requestedUpstream <= (long)REFILL_SIZE && this.s != null) {
                long u = (long)MAX_SIZE - SendPublisher.this.requestedUpstream;
                SendPublisher.this.requestedUpstream = Operators.addCap((long)SendPublisher.this.requestedUpstream, (long)u);
                this.s.request(u);
            }
        }

        private void flush() {
            try {
                SendPublisher.this.channel.flush();
                this.pendingFlush.set(false);
                SendPublisher.this.tryComplete(this);
            }
            catch (Throwable t) {
                this.onError(t);
            }
        }

        private void tryDrain() {
            if (SendPublisher.this.wip == 0 && SendPublisher.this.terminated == 0 && WIP.getAndIncrement(SendPublisher.this) == 0) {
                try {
                    if (SendPublisher.this.eventLoop.inEventLoop()) {
                        this.drain();
                    } else {
                        SendPublisher.this.eventLoop.execute(this::drain);
                    }
                }
                catch (Throwable t) {
                    this.onError(t);
                }
            }
        }

        private void drain() {
            try {
                int missed = 1;
                do {
                    ByteBuf ByteBuf2;
                    boolean scheduleFlush = false;
                    long r = Math.min(SendPublisher.this.requested, SendPublisher.this.requestedUpstream);
                    while (r-- > 0L && (ByteBuf2 = (ByteBuf)SendPublisher.this.queue.poll()) != null && SendPublisher.this.terminated == 0) {
                        ReferenceCounted poll = (ReferenceCounted)SendPublisher.this.transformer.apply(ByteBuf2);
                        int readableBytes = SendPublisher.this.sizeOf.size(poll);
                        SendPublisher.this.pending++;
                        if (SendPublisher.this.channel.isWritable() && (long)readableBytes <= SendPublisher.this.channel.bytesBeforeUnwritable()) {
                            SendPublisher.this.channel.write((Object)poll, SendPublisher.this.writeCleanupPromise(poll));
                            scheduleFlush = true;
                        } else {
                            scheduleFlush = false;
                            SendPublisher.this.channel.writeAndFlush((Object)poll, SendPublisher.this.writeCleanupPromise(poll));
                        }
                        this.tryRequestMoreUpstream();
                    }
                    if (!scheduleFlush) continue;
                    this.pendingFlush.set(true);
                    SendPublisher.this.eventLoop.execute(this::flush);
                } while (SendPublisher.this.terminated != 1 && (missed = WIP.addAndGet(SendPublisher.this, -missed)) != 0);
            }
            catch (Throwable t) {
                this.onError(t);
            }
        }
    }

    @FunctionalInterface
    static interface SizeOf<V> {
        public int size(V var1);
    }
}

