/*
 * Decompiled with CFR 0.152.
 */
package io.seata.saga.engine.pcext.handlers;

import io.seata.saga.engine.StateMachineConfig;
import io.seata.saga.engine.exception.EngineExecutionException;
import io.seata.saga.engine.pcext.StateHandler;
import io.seata.saga.engine.pcext.StateInstruction;
import io.seata.saga.engine.pcext.utils.CompensationHolder;
import io.seata.saga.engine.pcext.utils.EngineUtils;
import io.seata.saga.proctrl.ProcessContext;
import io.seata.saga.statelang.domain.ExecutionStatus;
import io.seata.saga.statelang.domain.StateInstance;
import io.seata.saga.statelang.domain.StateMachineInstance;
import java.util.List;
import java.util.Stack;

public class CompensationTriggerStateHandler
implements StateHandler {
    @Override
    public void process(ProcessContext context) throws EngineExecutionException {
        StateInstruction instruction = context.getInstruction(StateInstruction.class);
        StateMachineInstance stateMachineInstance = (StateMachineInstance)context.getVariable("_current_statemachine_instance_");
        StateMachineConfig stateMachineConfig = (StateMachineConfig)context.getVariable("_statemachine_config_");
        List<StateInstance> stateInstanceList = null;
        if (stateMachineInstance != null) {
            stateInstanceList = stateMachineInstance.getStateList();
        } else if (stateMachineConfig.getStateLogStore() != null) {
            stateInstanceList = stateMachineConfig.getStateLogStore().queryStateInstanceListByMachineInstanceId(stateMachineInstance.getId());
        }
        List<StateInstance> stateListToBeCompensated = CompensationHolder.findStateInstListToBeCompensated(context, stateInstanceList);
        if (stateListToBeCompensated != null && stateListToBeCompensated.size() > 0) {
            Exception e = (Exception)context.removeVariable("currentException");
            if (e != null) {
                stateMachineInstance.setException(e);
            }
            Stack<StateInstance> stateStackToBeCompensated = CompensationHolder.getCurrent(context, true).getStateStackNeedCompensation();
            stateStackToBeCompensated.addAll(stateListToBeCompensated);
            if (stateMachineInstance.getStatus() == null || ExecutionStatus.RU.equals((Object)stateMachineInstance.getStatus())) {
                stateMachineInstance.setStatus(ExecutionStatus.UN);
            }
            stateMachineInstance.setCompensationStatus(ExecutionStatus.RU);
            context.setVariable("_is_compensating_", instruction.getState(context));
        } else {
            EngineUtils.endStateMachine(context);
        }
    }
}

