/*
 * Decompiled with CFR 0.152.
 */
package io.seata.spring.tcc;

import io.seata.common.executor.Callback;
import io.seata.common.util.StringUtils;
import io.seata.core.context.RootContext;
import io.seata.rm.tcc.api.TwoPhaseBusinessAction;
import io.seata.rm.tcc.interceptor.ActionInterceptorHandler;
import io.seata.rm.tcc.remoting.RemotingDesc;
import io.seata.rm.tcc.remoting.parser.DubboUtil;
import io.seata.spring.util.SpringProxyUtils;
import java.lang.reflect.Method;
import java.util.Map;
import org.aopalliance.intercept.MethodInterceptor;
import org.aopalliance.intercept.MethodInvocation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TccActionInterceptor
implements MethodInterceptor {
    private static final Logger LOGGER = LoggerFactory.getLogger(TccActionInterceptor.class);
    private ActionInterceptorHandler actionInterceptorHandler = new ActionInterceptorHandler();
    protected RemotingDesc remotingDesc;

    public TccActionInterceptor() {
    }

    public TccActionInterceptor(RemotingDesc remotingDesc) {
        this.remotingDesc = remotingDesc;
    }

    public Object invoke(final MethodInvocation invocation) throws Throwable {
        Method method = this.getActionInterfaceMethod(invocation);
        TwoPhaseBusinessAction businessAction = method.getAnnotation(TwoPhaseBusinessAction.class);
        if (businessAction != null) {
            if (StringUtils.isBlank((String)RootContext.getXID())) {
                return invocation.proceed();
            }
            Object[] methodArgs = invocation.getArguments();
            Map ret = this.actionInterceptorHandler.proceed(method, methodArgs, businessAction, (Callback)new Callback<Object>(){

                public Object execute() throws Throwable {
                    return invocation.proceed();
                }
            });
            return ret.get("result");
        }
        return invocation.proceed();
    }

    protected Method getActionInterfaceMethod(MethodInvocation invocation) {
        try {
            Class<?> interfaceType = null;
            interfaceType = this.remotingDesc == null ? this.getProxyInterface(invocation.getThis()) : this.remotingDesc.getInterfaceClass();
            if (interfaceType == null && this.remotingDesc.getInterfaceClassName() != null) {
                interfaceType = Class.forName(this.remotingDesc.getInterfaceClassName(), true, Thread.currentThread().getContextClassLoader());
            }
            if (interfaceType == null) {
                return invocation.getMethod();
            }
            Method method = interfaceType.getMethod(invocation.getMethod().getName(), invocation.getMethod().getParameterTypes());
            return method;
        }
        catch (Exception e) {
            LOGGER.warn("get Method from interface failed", (Throwable)e);
            return invocation.getMethod();
        }
    }

    protected Class<?> getProxyInterface(Object proxyBean) throws Exception {
        if (proxyBean.getClass().getName().startsWith("com.alibaba.dubbo.common.bytecode.proxy")) {
            return DubboUtil.getAssistInterface((Object)proxyBean);
        }
        return SpringProxyUtils.getTargetInterface(proxyBean);
    }
}

