/*
 * Decompiled with CFR 0.152.
 */
package net.anumbrella.seaweedfs.core;

import java.io.IOException;
import net.anumbrella.seaweedfs.core.Connection;
import net.anumbrella.seaweedfs.util.ConnectionUtil;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.client.cache.HttpCacheStorage;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.InitializingBean;

public class FileSource
implements InitializingBean,
DisposableBean {
    private static final Log log = LogFactory.getLog(FileSource.class);
    private String host = "localhost";
    private int port = 9333;
    private int connectionTimeout = 3000;
    private int statusExpiry = 60;
    private int maxConnection = 100;
    private int idleConnectionExpiry = 60;
    private int maxConnectionsPreRoute = 1000;
    private boolean enableLookupVolumeCache = true;
    private int lookupVolumeCacheExpiry = 120;
    private int lookupVolumeCacheEntries = 100;
    private boolean enableFileStreamCache = true;
    private int fileStreamCacheEntries = 1000;
    private long fileStreamCacheSize = 8192L;
    private HttpCacheStorage fileStreamCacheStorage = null;
    private volatile boolean startup = false;
    private Connection connection;

    public Connection getConnection() {
        return this.connection;
    }

    public void startup() throws IOException {
        if (this.startup) {
            log.info((Object)"connect is already startup");
        } else {
            log.info((Object)("start connect to the seaweedfs master server [" + ConnectionUtil.convertUrlWithScheme(this.host + ":" + this.port) + "]"));
            if (this.connection == null) {
                this.connection = new Connection(ConnectionUtil.convertUrlWithScheme(this.host + ":" + this.port), this.connectionTimeout, this.statusExpiry, this.idleConnectionExpiry, this.maxConnection, this.maxConnectionsPreRoute, this.enableLookupVolumeCache, this.lookupVolumeCacheExpiry, this.lookupVolumeCacheEntries, this.enableFileStreamCache, this.fileStreamCacheEntries, this.fileStreamCacheSize, this.fileStreamCacheStorage);
            }
            this.connection.startup();
            this.startup = true;
        }
    }

    public void shutdown() {
        log.info((Object)"stop connect to the seaweedfs master server");
        if (this.connection != null) {
            this.connection.stop();
        }
    }

    public void afterPropertiesSet() throws Exception {
        this.startup();
    }

    public void destroy() throws Exception {
        this.shutdown();
    }

    public String getHost() {
        return this.host;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public int getPort() {
        return this.port;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public int getConnectionTimeout() {
        return this.connectionTimeout;
    }

    public void setConnectionTimeout(int connectionTimeout) {
        this.connectionTimeout = connectionTimeout;
    }

    public int getStatusExpiry() {
        return this.statusExpiry;
    }

    public void setStatusExpiry(int statusExpiry) {
        this.statusExpiry = statusExpiry;
    }

    public int getMaxConnection() {
        return this.maxConnection;
    }

    public void setMaxConnection(int maxConnection) {
        this.maxConnection = maxConnection;
    }

    public int getMaxConnectionsPreRoute() {
        return this.maxConnectionsPreRoute;
    }

    public void setMaxConnectionsPreRoute(int maxConnectionsPreRoute) {
        this.maxConnectionsPreRoute = maxConnectionsPreRoute;
    }

    public boolean isEnableLookupVolumeCache() {
        return this.enableLookupVolumeCache;
    }

    public void setEnableLookupVolumeCache(boolean enableLookupVolumeCache) {
        this.enableLookupVolumeCache = enableLookupVolumeCache;
    }

    public int getLookupVolumeCacheExpiry() {
        return this.lookupVolumeCacheExpiry;
    }

    public void setLookupVolumeCacheExpiry(int lookupVolumeCacheExpiry) {
        this.lookupVolumeCacheExpiry = lookupVolumeCacheExpiry;
    }

    public int getIdleConnectionExpiry() {
        return this.idleConnectionExpiry;
    }

    public void setIdleConnectionExpiry(int idleConnectionExpiry) {
        this.idleConnectionExpiry = idleConnectionExpiry;
    }

    public int getLookupVolumeCacheEntries() {
        return this.lookupVolumeCacheEntries;
    }

    public void setLookupVolumeCacheEntries(int lookupVolumeCacheEntries) {
        this.lookupVolumeCacheEntries = lookupVolumeCacheEntries;
    }

    public boolean isEnableFileStreamCache() {
        return this.enableFileStreamCache;
    }

    public void setEnableFileStreamCache(boolean enableFileStreamCache) {
        this.enableFileStreamCache = enableFileStreamCache;
    }

    public int getFileStreamCacheEntries() {
        return this.fileStreamCacheEntries;
    }

    public void setFileStreamCacheEntries(int fileStreamCacheEntries) {
        this.fileStreamCacheEntries = fileStreamCacheEntries;
    }

    public long getFileStreamCacheSize() {
        return this.fileStreamCacheSize;
    }

    public void setFileStreamCacheSize(long fileStreamCacheSize) {
        this.fileStreamCacheSize = fileStreamCacheSize;
    }

    public HttpCacheStorage getFileStreamCacheStorage() {
        return this.fileStreamCacheStorage;
    }

    public void setFileStreamCacheStorage(HttpCacheStorage fileStreamCacheStorage) {
        this.fileStreamCacheStorage = fileStreamCacheStorage;
    }
}

