/*
 * Decompiled with CFR 0.152.
 */
package net.anumbrella.seaweedfs.core;

import java.io.IOException;
import java.io.InputStream;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.Locale;
import java.util.TimeZone;
import net.anumbrella.seaweedfs.core.Connection;
import net.anumbrella.seaweedfs.core.MasterWrapper;
import net.anumbrella.seaweedfs.core.VolumeWrapper;
import net.anumbrella.seaweedfs.core.content.AssignFileKeyParams;
import net.anumbrella.seaweedfs.core.content.AssignFileKeyResult;
import net.anumbrella.seaweedfs.core.content.LocationResult;
import net.anumbrella.seaweedfs.core.content.LookupVolumeParams;
import net.anumbrella.seaweedfs.core.content.LookupVolumeResult;
import net.anumbrella.seaweedfs.core.file.FileHandleStatus;
import net.anumbrella.seaweedfs.core.http.HeaderResponse;
import net.anumbrella.seaweedfs.core.http.StreamResponse;
import net.anumbrella.seaweedfs.exception.SeaweedfsException;
import net.anumbrella.seaweedfs.exception.SeaweedfsFileDeleteException;
import net.anumbrella.seaweedfs.exception.SeaweedfsFileNotFoundException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.entity.ContentType;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.InitializingBean;

public class FileTemplate
implements InitializingBean,
DisposableBean {
    private static final Log log = LogFactory.getLog(FileTemplate.class);
    private static final SimpleDateFormat headerDateFormat = new SimpleDateFormat("EEE',' dd MMM yyyy HH:mm:ss 'GMT'", Locale.US);
    private MasterWrapper masterWrapper;
    private VolumeWrapper volumeWrapper;
    private int sameRackCount = 0;
    private int diffRackCount = 0;
    private int diffDataCenterCount = 0;
    private String replicationFlag = "000";
    private String timeToLive = null;
    private String dataCenter = null;
    private String collection = null;
    private boolean usingPublicUrl = true;
    private boolean loadBalance = true;
    private AssignFileKeyParams assignFileKeyParams = new AssignFileKeyParams();

    public FileTemplate(Connection connection) {
        this.masterWrapper = new MasterWrapper(connection);
        this.volumeWrapper = new VolumeWrapper(connection);
        headerDateFormat.setTimeZone(TimeZone.getTimeZone("GMT"));
    }

    public FileHandleStatus saveFileByStream(String fileName, InputStream stream) throws IOException {
        return this.saveFileByStream(fileName, stream, ContentType.DEFAULT_BINARY);
    }

    public FileHandleStatus saveFileByStream(String fileName, InputStream stream, ContentType contentType) throws IOException {
        AssignFileKeyResult assignFileKeyResult = this.masterWrapper.assignFileKey(this.assignFileKeyParams);
        String uploadUrl = this.usingPublicUrl ? assignFileKeyResult.getPublicUrl() : assignFileKeyResult.getUrl();
        return new FileHandleStatus(assignFileKeyResult.getFid(), this.volumeWrapper.uploadFile(uploadUrl, assignFileKeyResult.getFid(), fileName, stream, this.timeToLive, contentType), uploadUrl);
    }

    public LinkedHashMap<String, FileHandleStatus> saveFilesByStreamMap(LinkedHashMap<String, InputStream> streamMap) throws IOException {
        return this.saveFilesByStreamMap(streamMap, ContentType.DEFAULT_BINARY);
    }

    public LinkedHashMap<String, FileHandleStatus> saveFilesByStreamMap(LinkedHashMap<String, InputStream> streamMap, ContentType contentType) throws IOException {
        AssignFileKeyParams params = new AssignFileKeyParams(this.assignFileKeyParams.getReplication(), streamMap.size(), this.assignFileKeyParams.getDataCenter(), this.assignFileKeyParams.getTtl(), this.assignFileKeyParams.getCollection());
        AssignFileKeyResult assignFileKeyResult = this.masterWrapper.assignFileKey(params);
        String uploadUrl = this.usingPublicUrl ? assignFileKeyResult.getPublicUrl() : assignFileKeyResult.getUrl();
        LinkedHashMap<String, FileHandleStatus> resultMap = new LinkedHashMap<String, FileHandleStatus>();
        int index = 0;
        for (String fileName : streamMap.keySet()) {
            if (index == 0) {
                resultMap.put(fileName, new FileHandleStatus(assignFileKeyResult.getFid(), this.volumeWrapper.uploadFile(uploadUrl, assignFileKeyResult.getFid(), fileName, streamMap.get(fileName), this.timeToLive, contentType)));
            } else {
                resultMap.put(fileName, new FileHandleStatus(assignFileKeyResult.getFid() + "_" + String.valueOf(index), this.volumeWrapper.uploadFile(uploadUrl, assignFileKeyResult.getFid() + "_" + String.valueOf(index), fileName, streamMap.get(fileName), this.timeToLive, contentType)));
            }
            ++index;
        }
        return resultMap;
    }

    public void deleteFile(String fileId) throws IOException {
        String targetUrl = this.getTargetUrl(fileId);
        if (!this.volumeWrapper.checkFileExist(targetUrl, fileId)) {
            throw new SeaweedfsFileNotFoundException("file is not exist");
        }
        this.volumeWrapper.deleteFile(targetUrl, fileId);
    }

    public void deleteFiles(ArrayList<String> fileIds) throws IOException {
        if (fileIds != null) {
            for (String fileId : fileIds) {
                this.deleteFile(fileId);
            }
        }
    }

    public FileHandleStatus updateFileByStream(String fileId, String fileName, InputStream stream) throws IOException {
        return this.updateFileByStream(fileId, fileName, stream, ContentType.DEFAULT_BINARY);
    }

    public FileHandleStatus updateFileByStream(String fileId, String fileName, InputStream stream, ContentType contentType) throws IOException {
        String targetUrl = this.getTargetUrl(fileId);
        if (!this.volumeWrapper.checkFileExist(targetUrl, fileId)) {
            throw new SeaweedfsFileNotFoundException("file is not exist");
        }
        return new FileHandleStatus(fileId, this.volumeWrapper.uploadFile(targetUrl, fileId, fileName, stream, this.timeToLive, contentType));
    }

    public StreamResponse getFileStream(String fileId) throws IOException {
        String targetUrl = this.getTargetUrl(fileId);
        return this.volumeWrapper.getFileStream(targetUrl, fileId);
    }

    public FileHandleStatus getFileStatus(String fileId) throws IOException {
        String targetUrl = this.getTargetUrl(fileId);
        HeaderResponse headerResponse = this.volumeWrapper.getFileStatusHeader(targetUrl, fileId);
        try {
            return new FileHandleStatus(fileId, headerDateFormat.parse(headerResponse.getLastHeader("Last-Modified").getValue()).getTime(), headerResponse.getLastHeader("Content-Disposition").getValue().substring(10, headerResponse.getLastHeader("Content-Disposition").getValue().length() - 1), headerResponse.getLastHeader("Content-Type").getValue(), Long.parseLong(headerResponse.getLastHeader("Content-Length").getValue()));
        }
        catch (ParseException e) {
            throw new SeaweedfsException("Could not parse last modified time [" + headerResponse.getLastHeader("Last-Modified").getValue() + "] to long value");
        }
    }

    public String getFileUrl(String fileId) throws IOException {
        String targetUrl = this.getTargetUrl(fileId);
        return targetUrl + "/" + fileId;
    }

    public int getSameRackCount() {
        return this.sameRackCount;
    }

    public void setSameRackCount(int sameRackCount) {
        if (sameRackCount < 0 || sameRackCount > 9) {
            throw new IllegalArgumentException("seaweedfs replication at same rack count is error");
        }
        this.sameRackCount = sameRackCount;
        this.buildReplicationFlag();
        this.buildAssignFileKeyParams();
    }

    public int getDiffRackCount() {
        return this.diffRackCount;
    }

    public void setDiffRackCount(int diffRackCount) {
        if (diffRackCount < 0 || diffRackCount > 9) {
            throw new IllegalArgumentException("seaweedfs replication at diff rack count is error");
        }
        this.diffRackCount = diffRackCount;
        this.buildReplicationFlag();
        this.buildAssignFileKeyParams();
    }

    public int getDiffDataCenterCount() {
        return this.diffDataCenterCount;
    }

    public void setDiffDataCenterCount(int diffDataCenterCount) {
        if (diffDataCenterCount < 0 || diffDataCenterCount > 9) {
            throw new IllegalArgumentException("seaweedfs replication at diff data center count is error");
        }
        this.diffDataCenterCount = diffDataCenterCount;
        this.buildReplicationFlag();
        this.buildAssignFileKeyParams();
    }

    public String getTimeToLive() {
        return this.timeToLive;
    }

    public void setTimeToLive(String timeToLive) {
        this.timeToLive = timeToLive != null && timeToLive.trim().isEmpty() ? null : timeToLive;
        this.buildAssignFileKeyParams();
    }

    public String getDataCenter() {
        return this.dataCenter;
    }

    public void setDataCenter(String dataCenter) {
        this.dataCenter = dataCenter;
        this.buildAssignFileKeyParams();
    }

    public String getCollection() {
        return this.collection;
    }

    public void setCollection(String collection) {
        this.collection = collection;
        this.buildAssignFileKeyParams();
    }

    public boolean isUsingPublicUrl() {
        return this.usingPublicUrl;
    }

    public void setUsingPublicUrl(boolean usingPublicUrl) {
        this.usingPublicUrl = usingPublicUrl;
    }

    public boolean isLoadBalance() {
        return this.loadBalance;
    }

    public void setLoadBalance(boolean loadBalance) {
        this.loadBalance = loadBalance;
    }

    private void buildReplicationFlag() {
        this.replicationFlag = String.valueOf(this.diffDataCenterCount) + String.valueOf(this.diffRackCount) + String.valueOf(this.sameRackCount);
    }

    private void buildAssignFileKeyParams() {
        AssignFileKeyParams params = new AssignFileKeyParams();
        params.setCount(1);
        params.setTtl(this.timeToLive);
        params.setReplication(this.replicationFlag);
        params.setDataCenter(this.dataCenter);
        params.setCollection(this.collection);
        this.assignFileKeyParams = params;
    }

    private String getTargetUrl(String fileId) throws IOException {
        if (this.usingPublicUrl) {
            return this.getTargetLocation(fileId).getPublicUrl();
        }
        return this.getTargetLocation(fileId).getUrl();
    }

    private LocationResult getTargetLocation(String fileId) throws IOException {
        LookupVolumeResult volumeResult = this.masterWrapper.lookupVolume(new LookupVolumeParams(fileId, this.collection));
        if (volumeResult.getLocations() == null || volumeResult.getLocations().size() == 0) {
            throw new SeaweedfsFileDeleteException(fileId, new SeaweedfsException("can not found the volume server"));
        }
        return volumeResult.getLocations().iterator().next();
    }

    public void destroy() throws Exception {
        this.masterWrapper = null;
        this.volumeWrapper = null;
    }

    public void afterPropertiesSet() throws Exception {
    }
}

