/*
 * Decompiled with CFR 0.152.
 */
package net.anumbrella.seaweedfs.core;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.util.List;
import net.anumbrella.seaweedfs.core.Connection;
import net.anumbrella.seaweedfs.core.content.AssignFileKeyParams;
import net.anumbrella.seaweedfs.core.content.AssignFileKeyResult;
import net.anumbrella.seaweedfs.core.content.ForceGarbageCollectionParams;
import net.anumbrella.seaweedfs.core.content.LookupVolumeParams;
import net.anumbrella.seaweedfs.core.content.LookupVolumeResult;
import net.anumbrella.seaweedfs.core.content.PreAllocateVolumesParams;
import net.anumbrella.seaweedfs.core.content.PreAllocateVolumesResult;
import net.anumbrella.seaweedfs.core.http.JsonResponse;
import net.anumbrella.seaweedfs.core.topology.DataCenter;
import net.anumbrella.seaweedfs.core.topology.SystemTopologyStatus;
import net.anumbrella.seaweedfs.exception.SeaweedfsException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpRequestBase;
import org.ehcache.Cache;
import org.ehcache.CacheManager;

public class MasterWrapper {
    private static final Log log = LogFactory.getLog(MasterWrapper.class);
    private Connection connection;
    private Cache<Long, LookupVolumeResult> lookupVolumeCache;
    private ObjectMapper objectMapper = new ObjectMapper();

    public MasterWrapper(Connection connection) {
        this.connection = connection;
        CacheManager cacheManager = connection.getCacheManager();
        if (cacheManager != null) {
            this.lookupVolumeCache = cacheManager.getCache("lookupVolumeCache", Long.class, LookupVolumeResult.class);
        }
    }

    public AssignFileKeyResult assignFileKey(AssignFileKeyParams params) throws IOException {
        this.checkConnection();
        SystemTopologyStatus systemTopologyStatus = this.connection.getSystemTopologyStatus();
        List<DataCenter> dataCenterList = systemTopologyStatus.getDataCenters();
        params.setDataCenter(this.getOneAvailableDataCenter(dataCenterList).getId());
        log.info((Object)(" datacenter " + this.getOneAvailableDataCenter(dataCenterList) + " url " + params.toUrlParams()));
        String url = this.connection.getLeaderUrl() + "/dir/assign" + params.toUrlParams();
        HttpGet request = new HttpGet(url);
        JsonResponse jsonResponse = this.connection.fetchJsonResultByRequest((HttpRequestBase)request);
        return (AssignFileKeyResult)this.objectMapper.readValue(jsonResponse.json, AssignFileKeyResult.class);
    }

    private DataCenter getOneAvailableDataCenter(List<DataCenter> dataCenterList) {
        for (DataCenter dataCenter : dataCenterList) {
            if (dataCenter.getFree() == 0) continue;
            return dataCenter;
        }
        return dataCenterList.get(0);
    }

    public void forceGarbageCollection(ForceGarbageCollectionParams params) throws IOException {
        this.checkConnection();
        String url = this.connection.getLeaderUrl() + "/vol/vacuum" + params.toUrlParams();
        HttpGet request = new HttpGet(url);
        this.connection.fetchJsonResultByRequest((HttpRequestBase)request);
    }

    public PreAllocateVolumesResult preAllocateVolumes(PreAllocateVolumesParams params) throws IOException {
        this.checkConnection();
        String url = this.connection.getLeaderUrl() + "/vol/grow" + params.toUrlParams();
        HttpGet request = new HttpGet(url);
        JsonResponse jsonResponse = this.connection.fetchJsonResultByRequest((HttpRequestBase)request);
        return (PreAllocateVolumesResult)this.objectMapper.readValue(jsonResponse.json, PreAllocateVolumesResult.class);
    }

    public LookupVolumeResult lookupVolume(LookupVolumeParams params) throws IOException {
        this.checkConnection();
        if (this.lookupVolumeCache != null) {
            LookupVolumeResult result = (LookupVolumeResult)this.lookupVolumeCache.get((Object)params.getVolumeId());
            if (result != null) {
                return result;
            }
            result = this.fetchLookupVolumeResult(params);
            this.lookupVolumeCache.put((Object)params.getVolumeId(), (Object)result);
            return result;
        }
        return this.fetchLookupVolumeResult(params);
    }

    private LookupVolumeResult fetchLookupVolumeResult(LookupVolumeParams params) throws IOException {
        this.checkConnection();
        String url = this.connection.getLeaderUrl() + "/dir/lookup" + params.toUrlParams();
        HttpGet request = new HttpGet(url);
        JsonResponse jsonResponse = this.connection.fetchJsonResultByRequest((HttpRequestBase)request);
        return (LookupVolumeResult)this.objectMapper.readValue(jsonResponse.json, LookupVolumeResult.class);
    }

    private void checkConnection() throws SeaweedfsException {
        if (this.connection.isConnectionClose()) {
            throw new SeaweedfsException("connection is closed");
        }
    }
}

