/*
 * Decompiled with CFR 0.152.
 */
package net.anumbrella.seaweedfs.core;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import net.anumbrella.seaweedfs.core.Connection;
import net.anumbrella.seaweedfs.core.http.HeaderResponse;
import net.anumbrella.seaweedfs.core.http.JsonResponse;
import net.anumbrella.seaweedfs.core.http.StreamResponse;
import net.anumbrella.seaweedfs.exception.SeaweedfsException;
import net.anumbrella.seaweedfs.exception.SeaweedfsFileNotFoundException;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.HttpDelete;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpHead;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.mime.HttpMultipartMode;
import org.apache.http.entity.mime.MultipartEntityBuilder;
import org.apache.http.message.BasicHeader;
import org.apache.http.util.CharsetUtils;

public class VolumeWrapper {
    private Connection connection;
    private ObjectMapper objectMapper = new ObjectMapper();

    public VolumeWrapper(Connection Connection2) {
        this.connection = Connection2;
    }

    public long uploadFile(String url, String fid, String fileName, InputStream stream, String ttl, ContentType contentType) throws IOException {
        HttpPost httpPost = ttl != null ? new HttpPost(url + "/" + fid + "?ttl=" + ttl) : new HttpPost(url + "/" + fid);
        MultipartEntityBuilder builder = MultipartEntityBuilder.create();
        httpPost.setHeader((Header)new BasicHeader("Accept-Language", "zh-cn"));
        builder.setMode(HttpMultipartMode.BROWSER_COMPATIBLE);
        builder.setCharset(CharsetUtils.get((String)"UTF-8"));
        builder.addBinaryBody("upload", stream, contentType, fileName);
        HttpEntity entity = builder.build();
        httpPost.setEntity(entity);
        JsonResponse jsonResponse = this.connection.fetchJsonResultByRequest((HttpRequestBase)httpPost);
        if (jsonResponse == null) {
            jsonResponse = new JsonResponse("{\"name\":\"" + fileName + "\",\"size\":0}", 200);
        }
        this.convertResponseStatusToException(jsonResponse.statusCode, url, fid, false, false, false, false);
        return ((Integer)((Map)this.objectMapper.readValue(jsonResponse.json, Map.class)).get("size")).intValue();
    }

    public boolean checkFileExist(String url, String fid) throws IOException {
        HttpHead request = new HttpHead(url + "/" + fid);
        int statusCode = this.connection.fetchStatusCodeByRequest(request);
        try {
            this.convertResponseStatusToException(statusCode, url, fid, false, true, false, false);
            return true;
        }
        catch (SeaweedfsFileNotFoundException e) {
            return false;
        }
    }

    public void deleteFile(String url, String fid) throws IOException {
        HttpDelete request = new HttpDelete(url + "/" + fid);
        this.convertResponseStatusToException(this.connection.fetchJsonResultByRequest((HttpRequestBase)request).statusCode, url, fid, false, false, false, false);
    }

    public StreamResponse getFileStream(String url, String fid) throws IOException {
        HttpGet request = new HttpGet(url + "/" + fid);
        StreamResponse cache = this.connection.fetchStreamCacheByRequest((HttpRequestBase)request);
        this.convertResponseStatusToException(cache.getHttpResponseStatusCode(), url, fid, false, false, false, false);
        return cache;
    }

    public HeaderResponse getFileStatusHeader(String url, String fid) throws IOException {
        HttpHead request = new HttpHead(url + "/" + fid);
        HeaderResponse cache = this.connection.fetchHeaderByRequest(request);
        this.convertResponseStatusToException(cache.getHttpResponseStatusCode(), url, fid, false, false, false, false);
        return cache;
    }

    private void convertResponseStatusToException(int statusCode, String url, String fid, boolean ignoreNotFound, boolean ignoreRedirect, boolean ignoreRequestError, boolean ignoreServerError) throws SeaweedfsException {
        switch (statusCode / 100) {
            case 1: {
                return;
            }
            case 2: {
                return;
            }
            case 3: {
                if (ignoreRedirect) {
                    return;
                }
                throw new SeaweedfsException("fetch file from [" + url + "/" + fid + "] is redirect, " + "response stats code is [" + statusCode + "]");
            }
            case 4: {
                if (statusCode == 404 && ignoreNotFound) {
                    return;
                }
                if (statusCode == 404) {
                    throw new SeaweedfsFileNotFoundException("fetch file from [" + url + "/" + fid + "] is not found, " + "response stats code is [" + statusCode + "]");
                }
                if (ignoreRequestError) {
                    return;
                }
                throw new SeaweedfsException("fetch file from [" + url + "/" + fid + "] is request error, " + "response stats code is [" + statusCode + "]");
            }
            case 5: {
                if (ignoreServerError) {
                    return;
                }
                throw new SeaweedfsException("fetch file from [" + url + "/" + fid + "] is request error, " + "response stats code is [" + statusCode + "]");
            }
        }
        throw new SeaweedfsException("fetch file from [" + url + "/" + fid + "] is error, " + "response stats code is [" + statusCode + "]");
    }
}

